\name{pplot.t.test}
\alias{pplot.t.test}
\title{Generate p-plot from a series of data points}
\description{Takes a series of data points and computes either a chronological or ordered p-plot for testing the mean of the data points against 0 with a one-sample t-test.}
\usage{
pplot.t.test(data,
             sort = FALSE,
             startindex = 2,
             produce.plot = TRUE,
             xtitle = "Observation",
             plottype = 3,
             alpha = 0.05,
             alternative = "two.sided",
             n.sig = TRUE,
             n.sig.adjust = -1,
             ylim.p = c(0,1),
             ylim.es = -1,
             conf.level = 0.95,
             pcol.alpha = 125)
}

\arguments{
  \item{data}{Vector of data points.}
  \item{sort}{Logical. \code{TRUE} generates an ordered p-plot, \code{FALSE} generates a chronological p-plot.}
  \item{startindex}{Number of observations to begin the p-plot with (minimum 2).}
  \item{produce.plot}{Logical whether to produce plot or not. Setting to \code{FALSE} can be used to extract series of p-values as well as effect size estimates from the data.}
  \item{xtitle}{Axis title for the x-axis of the p-plot.}
  \item{plottype}{1 = only p-plot, 2 = only effect size plot, 3 = both plots.}
  \item{alpha}{Significance threshold to be used for determining oversampling.}
  \item{alternative}{Argument passed on to the \code{t.test()} function (see the corresponding documentation).}
  \item{n.sig}{Logical: Show vertical line at last crossing of the significance threshold?}
  \item{n.sig.adjust}{-1 = auto, 0 = left-adjusted, 0.5 = centered, 1 = right.}
  \item{ylim.p}{Plot limits on the y-axis of the p-plot. Vector of min, max.}
  \item{ylim.es}{Plot limits on the y-axis of the effect size plot. Either a vector of min and max, or only one value to be used as minimum with maximum being determined as a function of the data.}
  \item{conf.level}{Confidence level for effect size CIs.}
  \item{pcol.alpha}{Transparency of the data points; set to 255 for solid fill.}
}
\details{
\code{pplot.t.test} generates a chronological or ordered p-plot from a vector of data points. It returns a vector of p-values, or a data frame containing p-values and effect size estimates.
}
\value{
  \code{pplot.t.test()} returns either a vector of p-values, a data frame containing effect size estimates, or both (depending on the \code{plottype} argument).
}
% \references{}
\author{Roland Pfister}
% \note{}

\seealso{
  \code{\link{pplot.pvals}}; \code{\link[MBESS:ci.sm]{ci.sm}};
}
\examples{
# Show p-plot for significant test (the simulation 
# has a power of > 88% to return a significant 
# effect).
testdata <- rnorm(64, mean = 0.4, sd = 1)
pplot.t.test(testdata)

# Show p-plot for non-significant test (simulation 
# does not include a true effect).
testdata <- rnorm(64, mean = 0.0, sd = 1)
pplot.t.test(testdata)

}
\keyword{utilities}
