#' Paleoclimate Data for ppgm examples
#' 
#' North America paleoclimate data used for running ppgm
#' 
#' @format 'paleoclimate'
#' A large list of paleoclimates for North America, each element in the list contains a data frame for one time period, from present to 20mya
#' \describe{
#'  \item{GlobalID}{Global ID references for location}
#'  \item{Longitude}{Longitude of location}
#'  \item{Latitude}{Latitude of location}
#'  \item{bio1}{Value for bioclimatic variable 1: annual mean temperature}
#'  \item{bio2}{Value for bioclimatic variable 2: mean diurnal range}
#'  \item{bio3}{Value for bioclimatic variable 3: isothermality}
#'  \item{bio4}{Value for bioclimatic variable 4: temperature seasonality}
#'  \item{bio5}{Value for bioclimatic variable 5: max temp of warmest month}
#'  \item{bio6}{Value for bioclimatic variable 6: min temp of coldest month}
#'  \item{bio7}{Value for bioclimatic variable 7: temperature annual range}
#'  \item{bio8}{Value for bioclimatic variable 8: mean temp of wettest quarter}
#'  \item{bio9}{Value for bioclimatic variable 9: mean temp of driest quarter}
#'  \item{bio10}{Value for bioclimatic variable 10: mean temp of warmest quarter}
#'  \item{bio11}{Value for bioclimatic variable 11: mean temp of coldest quarter}
#'  \item{bio12}{Value for bioclimatic variable 12: annual precipitation}
#'  \item{bio13}{Value for bioclimatic variable 13: precipitation of wettest month}
#'  \item{bio14}{Value for bioclimatic variable 14: precipitation of the driest month}
#'  \item{bio15}{Value for bioclimatic variable 15: precipitation seasonality}
#'  \item{bio16}{Value for bioclimatic variable 16: precipitation of the wettest quarter}
#'  \item{bio17}{Value for bioclimatic variable 17: precipitation of the driest quarter}
#'  \item{bio18}{Value for bioclimatic variable 18: precipitation of the warmest quarter}
#'  \item{bio19}{Value for bioclimatic variable 19: precipitation of the coldest quarter}
#' }
"paleoclimate"