% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.r
\name{posterior_multivariate}
\alias{posterior_multivariate}
\title{Posterior Obtained by Updating Power Prior with Current Data (Multivariate)}
\usage{
posterior_multivariate(powerprior, current_data)
}
\arguments{
\item{powerprior}{Object of class "powerprior_multivariate" from
powerprior_multivariate()}

\item{current_data}{Matrix or data frame of current observations. Must have the
same number of columns as the historical data used to create the power prior.
Rows represent observations, columns represent variables.}
}
\value{
A list of class "posterior_multivariate" containing:
\item{mu_star}{Posterior mean vector}
\item{kappa_star}{Posterior precision parameter}
\item{nu_star}{Posterior degrees of freedom}
\item{Lambda_star}{Posterior scale matrix}
\item{n}{Sample size of current data}
\item{p}{Dimension of data}
\item{ybar}{Sample mean vector of current data}
\item{Sy}{Sum of squares and crossproducts matrix for current data}
\item{powerprior}{Original power prior object}
}
\description{
Updates a multivariate power prior with current trial data to obtain
the posterior distribution.
}
\details{
\subsection{Posterior Updating in the Multivariate Setting}{

Given a power prior P(\eqn{\mu}, \eqn{\Sigma} | X, \eqn{a_0}) and new current data Y, the posterior
distribution combines both through Bayes' theorem. The conjugate NIW structure
ensures the posterior remains a NIW distribution with closed-form parameters.

The updating mechanism mirrors the univariate case but extends to handle the
covariance matrix structure. The scale matrix \eqn{\Lambda^*} incorporates:
\enumerate{
\item Discounted historical sum of squares and crossproducts (\eqn{a_0} * S_x)
\item Prior scale information (\eqn{\Lambda_0}, if using informative prior)
\item Current data sum of squares and crossproducts (S_y)
\item Disagreement terms that increase uncertainty when historical and current means differ
}

The posterior mean vector is a precision-weighted average of the historical mean,
prior mean (if provided), and current mean, allowing for flexible incorporation
of multiple information sources with different precisions.
}
}
\examples{
library(MASS)
Sigma_true <- matrix(c(4, 1, 1, 2), 2, 2)
historical <- mvrnorm(50, mu = c(10, 5), Sigma = Sigma_true)
current <- mvrnorm(30, mu = c(10.5, 5.2), Sigma = Sigma_true)

# With vague prior
pp <- powerprior_multivariate(historical, a0 = 0.5)
posterior <- posterior_multivariate(pp, current)
print(posterior)

# With informative prior
pp_inform <- powerprior_multivariate(
  historical, a0 = 0.5,
  mu0 = c(10, 5), kappa0 = 1, nu0 = 5, Lambda0 = diag(2)
)
posterior_inform <- posterior_multivariate(pp_inform, current)
print(posterior_inform)

}
