% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptPLSc.R
\name{ptPLSc}
\alias{ptPLSc}
\title{post transformed PLS}
\usage{
ptPLSc(X, Y, W)
}
\arguments{
\item{X}{Data matrix where columns represent the \eqn{p} variables and
rows the \eqn{n} observations.}

\item{Y}{Vector of class probabilities}

\item{W}{Weight matrix where columns represent the \eqn{A} components and rows the \code{X} variables.}
}
\value{
List with the following objects:
\describe{
  \item{W}{Matrix of weights}
  \item{G}{Post transformation matrix}
  \item{M}{Number of orthogonal components}
}
}
\description{
Performs post transformed Partial Least Squares
}
\references{
Stocchero, M., & Paris, D. (2016). Post-transformation of PLS2 (ptPLS2) by orthogonal matrix: a new approach for generating predictive and orthogonal latent variables. Journal of Chemometrics, 30(5), 242-251.
}
\seealso{
\code{\link{PLSc}}, \code{\link{computeWT}}
}
\author{
Angela Andreella
}
\keyword{internal}
