% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rctglm_prog_methods.R
\name{prog}
\alias{prog}
\alias{prog.rctglm_prog}
\title{Extract information about the fitted prognostic model}
\usage{
prog(x)

\method{prog}{rctglm_prog}(x)
}
\arguments{
\item{x}{an object of class \code{rctglm_prog} (returned by
\link{rctglm_with_prognosticscore})}
}
\value{
a list with the structure described of \code{prognostic_info} in the
\code{Value} section of \link{rctglm_with_prognosticscore}.
}
\description{
Extracts the \code{prognostic_info} list element from an \code{rctglm_prog} object. See
'Value' at \link{rctglm_with_prognosticscore} for more details.
}
\examples{
# Generate some data
n <- 100
b0 <- 1
b1 <- 1.5
b2 <- 2
W1 <- runif(n, min = 1, max = 10)
exposure_prob <- .5

dat_treat <- glm_data(
  Y ~ b0+b1*log(W1)+b2*A,
  W1 = W1,
  A = rbinom(n, 1, exposure_prob)
)

dat_notreat <- glm_data(
  Y ~ b0+b1*log(W1),
  W1 = W1
)

learners <- list(
  mars = list(
    model = parsnip::set_engine(
      parsnip::mars(
        mode = "regression", prod_degree = 3
      ),
      "earth"
    )
  )
)
ate <- rctglm_with_prognosticscore(
  formula = Y ~ .,
  exposure_indicator = A,
  exposure_prob = exposure_prob,
  data = dat_treat,
  family = gaussian(),
  estimand_fun = "ate",
  data_hist = dat_notreat,
  learners = learners)

prog(ate)

}
\seealso{
The generic \code{\link[=rctglm_with_prognosticscore]{rctglm_with_prognosticscore()}} for which this method
works.
}
