% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_robin.R
\name{rrmlg}
\alias{rrmlg}
\title{Round Robin Multilocus Genotypes}
\usage{
rrmlg(gid)
}
\arguments{
\item{gid}{a genind, genclone, or loci object.}
}
\value{
a matrix of multilocus genotype assignments by masked locus. There
  will be n rows and m columns where n = number of samples and m = number of
  loci.
}
\description{
This function will mask each locus one by one and then calculate multilocus
genotypes from the remaining loci in a round-robin fashion. This is used for
calculating the round robin allele frequencies for pgen and psex.
}
\examples{

# Find out the round-robin multilocus genotype assignments for P. ramorum
data(Pram)
pmlg_rr <- rrmlg(Pram)
head(pmlg_rr)
\dontrun{
# You can find out how many unique genotypes are found without each locus:

colSums(!apply(pmlg_rr, 2, duplicated))
}
}
\references{
Arnaud-Haond, S., Duarte, C. M., Alberto, F., & Serrão, E. A. 2007.
Standardizing methods to address clonality in population studies.
\emph{Molecular Ecology}, 16(24), 5115-5139.

Parks, J. C., & Werth, C. R. 1993. A study of spatial features of clones in a
population of bracken fern, \emph{Pteridium aquilinum} (Dennstaedtiaceae).
\emph{American Journal of Botany}, 537-544.
}
\seealso{
\code{\link{rraf}}, \code{\link{pgen}}, \code{\link{psex}}
}
\author{
Zhian N. Kamvar, Jonah Brooks, Stacy A. Krueger-Hadfield, Erik Sotka
}
