% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eig.R
\name{eigs}
\alias{eigs}
\title{Calculate asymptotic growth}
\usage{
eigs(A, what = "all", check = TRUE)
}
\arguments{
\item{A}{a square, nonnegative numeric matrix of any dimension.}

\item{what}{what components of the dominant eigenstuff should be returned. 
A character vector, which may include:
\describe{
 \item{\code{"lambda"}}{the dominant eigenvalue (lambda)}
 \item{\code{"ss"}}{the dominant right eigenvector (stable stage)}
 \item{\code{"rv"}}{the dominant left eigenvector (reproductive value)}
}
the default, \code{"all"}, returns all of the above.}

\item{check}{(logical) determines whether the dominant eigenvalue is 
checked for nonzero imaginary component, and largest absolute value. If
either of these occur, then the dominant eigenvalue may not be described as 
truly dominant.}
}
\value{
A list with possible components that depends on the contents of \code{what}:
\describe{
\item{lambda}{ 
the dominant eigenvalue, which describes asymptotic population growth (if A 
is primitive; see \code{\link{isPrimitive}}). A real, nonnegative numeric 
vector of length 1. 
}
\item{ss}{
the dominant right eigenvector, which describes the stable age/stage structure
(if \code{A} is primitive; see \code{\link{isPrimitive}}). A real, nonnegative 
numeric vector equal to the dimension of \code{A} in length, scaled to sum to 1.
}
\item{rv}{
the dominant left eigenvector, which describes the reproductive value (if 
\code{A} is primitive; see \code{\link{isPrimitive}}). A real, nonnegative 
numeric vector equal to the dimension of \code{A} in length, scaled so that 
rv%*%ss equals 1.
}
}

If only one of these components is returned, then the value is not a list, but 
a single numeric vector.
}
\description{
Dominant eigenstuff of a population matrix projection model.
}
\details{
\code{eigs} gives the dominant eigenstuff of a population projection model. 
This includes the dominant eigenvalue (asymptotic population growth), the 
dominant right eigenvector (stable age/stage distribution), and the dominant
left eigenvector (reproductive value). The dominant eigenvalue is the 
eigenvalue with the largest real component, and the dominant eigenvectors are 
the eigenvectors that correspond to this eigenvalue. If the matrix is 
reducible, then there may be other real or complex eigenvalues whose absolute
value are equal in magnitude to that of the dominant eigenvalue. In this case,
\code{eigs} returns the first one, and gives a warning "More than one eigenvalues 
have equal absolute magnitude", for information.
}
\examples{
  # load the desert tortoise data
  data(Tort)
  
  # find the dominant eigenvalue
  eigs(Tort, "lambda")
  
  #find the stable stage structure
  eigs(Tort, "ss")
  
  #find the reproductive value
  eigs(Tort, "rv")
  
  #find both dominant eigenvectors
  eigs(Tort, c("ss","rv"))
  
  #find all eigenstuff
  eigs(Tort)

}
\concept{Eigenstuff}
\concept{GrowthMeasures}
\concept{asymptotic}
\concept{eigenvalues}
\concept{growth}
\concept{population structure}
\concept{reproductive value}
\concept{stable}
