% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynaMaze.R
\docType{data}
\name{DynaMaze}
\alias{DynaMaze}
\alias{dynamaze}
\title{The Dyna Maze}
\format{
An object of class \link{MDP}.
}
\description{
The Dyna Maze from Chapter 8 of the textbook
"Reinforcement Learning: An Introduction."
}
\details{
The simple 6x9 maze with a few walls.
}
\examples{
data(DynaMaze)

DynaMaze

gridworld_matrix(DynaMaze)
gridworld_matrix(DynaMaze, what = "labels")

gridworld_plot_transition_graph(DynaMaze)
}
\references{
Richard S. Sutton and Andrew G. Barto (2018). Reinforcement Learning: An Introduction
Second Edition, MIT Press, Cambridge, MA.
}
\seealso{
Other MDP_examples: 
\code{\link{Cliff_walking}},
\code{\link{MDP}()},
\code{\link{Maze}},
\code{\link{Windy_gridworld}}

Other gridworld: 
\code{\link{Cliff_walking}},
\code{\link{Maze}},
\code{\link{Windy_gridworld}},
\code{\link{gridworld}}

Other MDP_examples: 
\code{\link{Cliff_walking}},
\code{\link{MDP}()},
\code{\link{Maze}},
\code{\link{Windy_gridworld}}

Other gridworld: 
\code{\link{Cliff_walking}},
\code{\link{Maze}},
\code{\link{Windy_gridworld}},
\code{\link{gridworld}}
}
\concept{MDP_examples}
\concept{gridworld}
\keyword{datasets}
