% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poLCAParallel.se.R
\name{poLCAParallel.se}
\alias{poLCAParallel.se}
\title{Calculates the standard errors and adds them to a fitted poLCA model object}
\usage{
poLCAParallel.se(polca, is_smooth = FALSE)
}
\arguments{
\item{polca}{A model object estimated using the \code{poLCA} function}

\item{is_smooth}{Logical, experimental, for calculating the standard errors,
whether to smooth the outcome probabilities to produce more numerical stable
results at the cost of bias.}
}
\value{
the fitted poLCA model object with the attributes \verb{$P.se},
\verb{$probs.se}, \verb{$coeff.se} and '$coeff.V` modified or added
}
\description{
Calculates the standard errors and adds them, as attributes, to a fitted
poLCA model object \verb{$P.se}, \verb{$probs.se}, \verb{$coeff.se} and \verb{$coeff.V}
}
\details{
R wrapper function for the C++ function \code{StandardErrorRcpp()}

\verb{$coeff.se} and \verb{$coeff.V} are set to \code{NA} if the provided poLCA is a poLCA
problem with no regression
}
