% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state.R
\name{der_state_plot_nm}
\alias{der_state_plot_nm}
\title{Generate Derivative versus State Plot (NONMEM)}
\usage{
der_state_plot_nm(
  nn_name,
  min_state = NULL,
  max_state = NULL,
  inputs = NULL,
  est_parms = NULL,
  nm_res_file = NULL,
  length_out = 100,
  time_nn = FALSE,
  act = "ReLU",
  plot_type = c("base", "ggplot"),
  beta = 20,
  transform = NULL
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{min_state}{(numeric) Value of minimal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{max_state}{(numeric) Value of maximal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{inputs}{(numeric vector) Vector of input values for which derivatives should be calculated (optional if min_state and max_state is given)}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters from the NN extracted through the \emph{pre_fixef_extractor_nm} function. For optionality, see \strong{Details}.}

\item{nm_res_file}{(string; semi-optional) (path)/name of the results file of a NONMEM run, must include file extension, e.g., “.res”. For optionality, see \strong{Details}.}

\item{length_out}{(numeric) Number of states between min_state and max_state for derivative calculations.}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{plot_type}{(string) What plot type should be used; "base" or "ggplot"}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}

\item{transform}{(string) Mathematical exression as string to transform the NN output. Independent variable must be called NN, e.g.,
"1/(1+exp(-NN))" for sigmoidal transformation.}
}
\value{
Displaying derivative versus state plot; returns ggplot-object if \emph{plot_type="ggplot"}
}
\description{
This functions allows to generate a derivative versus state plot for a neural network from a NODE in NONMEM.
Can also be used for nlmixr2.
}
\details{
Either \emph{est_parms} or \emph{nm_res_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
res_path <- system.file("extdata","nm_example1_model_converted_ind.res",package="pmxNODE")
der_state_plot <- der_state_plot_nm(nn="c",
                                    min_state=0,max_state=10,
                                    nm_res_file=res_path,
                                    plot_type="ggplot")
}
\author{
Dominic Bräm
}
