% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas.r
\name{BrailleCanvas}
\alias{BrailleCanvas}
\title{Braille Canvas Class}
\description{
Braille Canvas Class

Braille Canvas Class
}
\details{
High-resolution canvas using Unicode Braille patterns.
Resolution: 2x4 (2 horizontal, 4 vertical dots per character = 8x resolution)

Braille dot layout (dot numbers and bit values):
\preformatted{
       Col 0  Col 1     Bit values
Row 0:   1      4        0x01  0x08
Row 1:   2      5        0x02  0x10
Row 2:   3      6        0x04  0x20
Row 3:   7      8        0x40  0x80
}
}
\section{Super class}{
\code{\link[plotcli:Canvas]{plotcli::Canvas}} -> \code{BrailleCanvas}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{braille_base}}{Unicode code point for empty Braille character}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BrailleCanvas-new}{\code{BrailleCanvas$new()}}
\item \href{#method-BrailleCanvas-get_dot_bit}{\code{BrailleCanvas$get_dot_bit()}}
\item \href{#method-BrailleCanvas-set_pixel}{\code{BrailleCanvas$set_pixel()}}
\item \href{#method-BrailleCanvas-clone}{\code{BrailleCanvas$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="apply_colors"><a href='../../plotcli/html/Canvas.html#method-Canvas-apply_colors'><code>plotcli::Canvas$apply_colors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="clear"><a href='../../plotcli/html/Canvas.html#method-Canvas-clear'><code>plotcli::Canvas$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_circle"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_circle'><code>plotcli::Canvas$draw_circle()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_hline"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_hline'><code>plotcli::Canvas$draw_hline()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_line"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_line'><code>plotcli::Canvas$draw_line()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_points"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_points'><code>plotcli::Canvas$draw_points()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_polygon"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_polygon'><code>plotcli::Canvas$draw_polygon()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_polyline"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_polyline'><code>plotcli::Canvas$draw_polyline()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_rect"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_rect'><code>plotcli::Canvas$draw_rect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_segment"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_segment'><code>plotcli::Canvas$draw_segment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_text"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_text'><code>plotcli::Canvas$draw_text()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="draw_vline"><a href='../../plotcli/html/Canvas.html#method-Canvas-draw_vline'><code>plotcli::Canvas$draw_vline()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_area"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_area'><code>plotcli::Canvas$fill_area()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_bar"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_bar'><code>plotcli::Canvas$fill_bar()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_circle"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_circle'><code>plotcli::Canvas$fill_circle()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="fill_rect"><a href='../../plotcli/html/Canvas.html#method-Canvas-fill_rect'><code>plotcli::Canvas$fill_rect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="print"><a href='../../plotcli/html/Canvas.html#method-Canvas-print'><code>plotcli::Canvas$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plotcli" data-topic="Canvas" data-id="render"><a href='../../plotcli/html/Canvas.html#method-Canvas-render'><code>plotcli::Canvas$render()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BrailleCanvas-new"></a>}}
\if{latex}{\out{\hypertarget{method-BrailleCanvas-new}{}}}
\subsection{Method \code{new()}}{
Initialize Braille canvas
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BrailleCanvas$new(width, height)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Character width}

\item{\code{height}}{Character height}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BrailleCanvas-get_dot_bit"></a>}}
\if{latex}{\out{\hypertarget{method-BrailleCanvas-get_dot_bit}{}}}
\subsection{Method \code{get_dot_bit()}}{
Get the bit value for a dot position
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BrailleCanvas$get_dot_bit(dot_row, dot_col)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dot_row}}{Row within Braille cell (0-3)}

\item{\code{dot_col}}{Column within Braille cell (0-1)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Bit value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BrailleCanvas-set_pixel"></a>}}
\if{latex}{\out{\hypertarget{method-BrailleCanvas-set_pixel}{}}}
\subsection{Method \code{set_pixel()}}{
Set a pixel in Braille space
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BrailleCanvas$set_pixel(x, y, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{X coordinate (1-based, in pixel space: 1 to width*2)}

\item{\code{y}}{Y coordinate (1-based, in pixel space: 1 to height*4, 1 = top)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BrailleCanvas-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BrailleCanvas-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BrailleCanvas$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
