% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pleiotropyh2_cor_computing_single_prune.R
\name{pleiotropyh2_cor_computing_single_prune}
\alias{pleiotropyh2_cor_computing_single_prune}
\title{Compute pleioh2g after bias correction for target disease}
\usage{
pleiotropyh2_cor_computing_single_prune(
  G,
  phenotype,
  h2_vector,
  h2_vector_mat,
  Results_full_rg,
  Results_full_rg_array,
  sample_rep
)
}
\arguments{
\item{G}{index of target disease.}

\item{phenotype}{Vector of the phenotype name}

\item{h2_vector}{h2g vector for all traits - aligned as the order in phenotype file}

\item{h2_vector_mat}{h2g array from jackknife-block estimates for all traits - aligned as the order in phenotype file}

\item{Results_full_rg}{genetic correlation matrix. - aligned as the order in phenotype file}

\item{Results_full_rg_array}{genetic correlation jackknife-block array. - aligned as the order in phenotype file}

\item{sample_rep}{sampling times in bias correction}
}
\value{
A `list` containing the following elements:
  - `target_disease` (character): The value "401.1".
  - `target_disease_h2_est` (numeric): target disease h2g.
  - `target_disease_h2_se` (numeric): target disease h2g_se.
  - `selected_auxD` (character): auxiliary diseases.
  - `h2pleio_uncorr` (numeric): pre-correction pleiotropic heritability estimate.
  - `h2pleio_uncorr_se` (numeric): pre-correction pleiotropic heritability jackknife s.e. estimate.
  - `percentage_h2pleio_uncorr` (numeric): pre-correction percentage of pleiotropic heritability estimate.
  - `percentage_h2pleio_uncorr_se` (numeric): pre-correction percentage of pleiotropic heritability jackknife s.e. estimate.
  - `percentage_h2pleio_uncorr_jackknife` (numeric): vector of all pre-correction percentage of pleiotropic heritability jackknife estimates.
  - `h2pleio_corr` (numeric): post-correction pleiotropic heritability estimate.
  - `h2pleio_corr_se` (numeric): post-correction pleiotropic heritability estimate s.e..
  - `percentage_h2pleio_corr` (numeric): post-correction percentage of pleiotropic heritability estimate.
  - `percentage_h2pleio_corr_se` (numeric): post-correction percentage of pleiotropic heritability jackknife s.e. estimate.
  - `percentage_h2pleio_corr_Z` (numeric): post-correction percentage of pleiotropic heritability estimate Z score.
  - `corrected_weight` (numeric): corrected weight in bias correction.
}
\description{
This function is used to compute pleioh2g after bias correction for target disease
}
\examples{
\donttest{
G <- 1
data(Results_full_rg)
data(Results_full_rg_array)
data(h2_vector)
data(h2_vector_mat)
Results_full_rg<-Results_full_rg[1:15,1:15]
Results_full_rg_array<-Results_full_rg_array[1:15,1:15,]
h2_vector<-t(as.matrix(h2_vector[1,1:15]))
h2_vector_mat<-h2_vector_mat[,1:15]
phenotype<-c("401.1","244.5","318","735.3","411.4",
"427.2","454.1","278.1","250.2","550.1","530.11",
"296.22","519.8","562.1","763")
sample_rep<-20
post_corrrresults_prune<-pleiotropyh2_cor_computing_single_prune(G,phenotype,h2_vector,
h2_vector_mat,Results_full_rg,Results_full_rg_array, sample_rep)
}
}
