% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plater-package.R, R/plater.R
\docType{package}
\name{plater-package}
\alias{plater-package}
\title{plater: Read, Tidy, and Display Data from Microtiter Plates}
\description{
Tools for interacting with data from experiments done in microtiter plates. Easily read in plate-shaped data and convert it to tidy format, combine plate-shaped data with tidy data, and view tidy data in plate shape.

plater defines a simple, plate-shaped file format for data storage, so it's 
easy to remember the experimental design. The package provides functions to 
seamlessly convert between that format and a tidy data frame that's optimal 
for analysis. \code{\link[plater]{check_plater_format}} is provided to help 
you manage plate-shaped files. \cr\cr You can work with purely plate-shaped 
data (\code{\link[plater]{read_plate}} and 
\code{\link[plater]{read_plates}}), as well as with a combination of 
plate-shaped data and tidy data (\code{\link[plater]{add_plate}}). It further
allows easy plate-shaped visualization of tidy data 
(\code{\link[plater]{view_plate}}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/plater/}
  \item \url{https://github.com/ropensci/plater}
  \item Report bugs at \url{https://github.com/ropensci/plater/issues}
}


Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/plater/}
  \item \url{https://github.com/ropensci/plater}
  \item Report bugs at \url{https://github.com/ropensci/plater/issues}
}

}
\author{
\strong{Maintainer}: Sean Hughes \email{smhughes@uw.edu} (\href{https://orcid.org/0000-0002-9409-9405}{ORCID})

}
\keyword{internal}
