% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRecruits.R
\name{getRecruits}
\alias{getRecruits}
\title{Calculates the number of recruits of each species per year in each quadrat}
\usage{
getRecruits(
  dat,
  byGenet = TRUE,
  species = "Species",
  quad = "Quad",
  site = "Site",
  year = "Year",
  trackID = "trackID",
  recruit = "recruit",
  ...
)
}
\arguments{
\item{dat}{An sf data.frame in which each row represents a unique polygon
(either a genet or a ramet) in a unique site/quadrat/year combination. A
data.frame returned by \code{\link{trackSpp}} can be put directly into this
function. 'dat' must have columns that contain...
\itemize{
\item a unique identification for each research site in character format
with no NAs (the default column name is "Site")
\item species name in character format with no NAs (the default column
name is "Species")
\item unique quadrat identifier in character format with no NAs (the default
column name is "Quad")
\item year of data collection in integer format with no NAs (the
default column name is "Year")
\item a unique identifier for each genet in character format with no NAs (the
default column name is "trackID")
\item an s.f 'geometry' column that contains a polygon or multipolygon data type
for each individual observation (the default column name is "geometry")
}}

\item{byGenet}{A logical argument. \code{TRUE} indicates that a new genet will be
considered as only one recruit, even if it consists of multiple ramets.
\code{FALSE} indicates that each new ramet will be considered as a new recruit,
even if other ramets of the same genet were present in previous years.}

\item{species}{An optional character string argument. Indicates
the name of the column in 'dat' that contains species name data. It is
unnecessary to include a value for this argument if the column name is
"Species" (default value is 'Species').}

\item{quad}{An optional character string argument. Indicates
the name of the column in 'dat' that contains quadrat name data. It is
unnecessary to include a value for this argument if the column name is
"Quad" (default is 'Quad').}

\item{site}{An optional character string argument. Indicates
the name of the column in 'dat' that contains site name data. It is
unnecessary to include a value for this argument if the column name is
"Site" (default value is 'Site').}

\item{year}{An optional character string argument. Indicates
the name of the column in 'dat' that contains data for year of sampling. It
is unnecessary to include a value for this argument if the column name is
"Year" (default is 'Year').}

\item{trackID}{An optional character string argument. Indicates the name of
the column in 'dat' that contains unique identifiers for each genet. It is
unnecessary to include a value for this argument if the column name is
"trackID" (default is 'trackID')}

\item{recruit}{An optional character string argument. Indicates the name of
the column in 'dat' that contains information indicating whether or not this
row represents data for a recruit. It is unnecessary to include a value for
this argument if the column name is "recruit" (default is "recruit").}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
This function returns a data frame with the columns 'Site', 'Quad',
'speciesName', 'Year', and 'recruits'. The 'recruits' column contains a count
of the number of individuals of the species and in the site, quadrat, and
year indicated in the other columns of the data frame.
}
\description{
This function calculates the number of new recruits of
each species in each quadrat in each year. The input data must already
contain a column indicating whether each observation is classified as a
recruit or not. This recruit status can be generated from the
\code{\link{trackSpp}} function in \code{plantTracker}, or can be information that
was collected in the field. This function includes an option that determines
whether each ramet of a clonal species is considered an individual recruit,
or if the entire genet is considered a single recruit.
}
\examples{
dat <- grasslandData[grasslandData$Site == c("AZ") &
 grasslandData$Species \%in\% c("Bouteloua rothrockii",
 "Calliandra eriophylla") &
 grasslandData$Year \%in\% c(1922:1925),]
names(dat)[1] <- "speciesName"
inv <- grasslandInventory[unique(dat$Quad)]
outDat <- trackSpp(dat = dat,
 inv = inv,
 dorm = 1,
 buff = .05,
 buffGenet = 0.005,
 clonal = data.frame("Species" = unique(dat$speciesName),
 "clonal" = c(TRUE,FALSE)),
 species = "speciesName",
 aggByGenet = TRUE
 )
 getRecruits(dat = outDat,
 byGenet = TRUE,
 species = "speciesName"
 )

}
