% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_dependencies}
\alias{get_dependencies}
\title{Get (reverse) dependencies of a set of packages}
\usage{
get_dependencies(
  packages,
  level = 1L,
  relation = c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances"),
  strict = FALSE,
  ignore = c("datasets", "utils", "grDevices", "graphics", "stats", "methods"),
  reverse = FALSE
)
}
\arguments{
\item{packages}{(\code{chr}) Package names}

\item{level}{(\code{count(1)}) Depth of recursive dependency}

\item{relation}{(\code{chr}) Types of relations. Must be a subset of
c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}

\item{strict}{(\code{flag[T]}) Whether to consider all packages
(alternately only 'relation' specific packages) when computing dependencies
for the next level.}

\item{ignore}{(\code{chr}) package names to ignore.}

\item{reverse}{(\code{flag[F]}) Whether to get reverse dependencies.}
}
\value{
(\code{dataframe}) with three columns: \code{pkg_1}, \code{relation} and \code{pkg_2}
}
\description{
Get (reverse) dependencies of a set of packages till a certain
depth(\code{level}) for a set of dependency types (\code{relation}).
}
\examples{
\dontrun{
init()
get_dependencies("mlr3") |>
get_dependencies("mlr3", level = 2)
get_dependencies("mlr3", level = 2, reverse = TRUE)
get_dependencies("mlr3", level = 2, relation = "Imports")
# setting strict to TRUE to only consider 'Imports' of the previous level
get_dependencies("mlr3",
                 level    = 2,
                 relation = "Imports",
                 strict   = TRUE
                 )
}
}
\seealso{
\link{get_neighborhood}
}
