% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_dea.R
\name{compute_dea}
\alias{compute_dea}
\title{Compute DEA}
\usage{
compute_dea(
  data,
  input,
  output,
  id = NULL,
  rts = c("crs", "vrs", "drs", "irs"),
  orientation = c("in", "out"),
  super = FALSE,
  slack = FALSE,
  peers = FALSE
)
}
\arguments{
\item{data}{Dataset to analyse.}

\item{input}{A character vector with input variables.}

\item{output}{A character vector with output variables.}

\item{id}{Optional. A string with the DMU id or name variable. Defaults to the rownames of the dataset.}

\item{rts}{Returns to scale.
\tabular{rlll}{
\tab crs \tab\tab Constant returns to scale, convexity and free disposability. \cr
\tab vrs \tab\tab Variable returns to scale, convexity and free disposability. \cr
\tab drs \tab\tab Decreasing returns to scale, convexity, down-scaling and free disposability. \cr
\tab irs \tab\tab Increasing returns to scale, (up-scaling, but not down-scaling), convexity and free disposability.
}}

\item{orientation}{Model orientation.}

\item{super}{If \code{TRUE} super efficiency scores are calculated.}

\item{slack}{If \code{TRUE} slack values are calculated.}

\item{peers}{If \code{TRUE} peers are added to the response.}
}
\value{
A list of class \code{pioneer_dea}.
}
\description{
Solve an input or output oriented DEA model under constant (\code{crs}), variable (\code{vrs}),
non-increasing (\code{drs}), or non-decreasing (\code{irs}) returns to scale.
}
\examples{
# Load example data
fare89 <- deaR::Electric_plants
# Estimate efficiency
mod <- compute_dea(
  data = fare89,
  input = c("Labor", "Fuel", "Capital"),
  output = "Output",
  id = "Plant",
  rts = "vrs",
  orientation = "in"
)
# Print results
print(mod)
# Get summary
summary(mod)
# Convert to data frame
df <- as.data.frame(mod)
}
