% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistence-class.R
\name{persistence}
\alias{persistence}
\alias{as_persistence}
\alias{as_persistence.list}
\alias{as_persistence.persistence}
\alias{as_persistence.data.frame}
\alias{as_persistence.matrix}
\alias{as_persistence.diagram}
\alias{as_persistence.PHom}
\alias{as_persistence.hclust}
\alias{print.persistence}
\alias{format.persistence}
\alias{get_pairs}
\alias{as.matrix.persistence}
\alias{as.data.frame.persistence}
\title{An \code{S3} class for storing persistence data}
\usage{
as_persistence(x, warn = TRUE, ...)

\method{as_persistence}{list}(x, warn = TRUE, ...)

\method{as_persistence}{persistence}(x, warn = TRUE, ...)

\method{as_persistence}{data.frame}(x, warn = TRUE, ...)

\method{as_persistence}{matrix}(x, warn = TRUE, ...)

\method{as_persistence}{diagram}(x, warn = TRUE, ...)

\method{as_persistence}{PHom}(x, ...)

\method{as_persistence}{hclust}(x, warn = TRUE, birth = NULL, ...)

\method{print}{persistence}(x, ...)

\method{format}{persistence}(x, ...)

get_pairs(x, dimension, ...)

\method{as.matrix}{persistence}(x, ...)

\method{as.data.frame}{persistence}(x, row.names = NULL, optional = TRUE, ...)
}
\arguments{
\item{x}{An \code{R} object containing the persistence data to be coerced into an
object of class \code{\link{persistence}}. Currently supported forms are:
\itemize{
\item a \eqn{\geq 2}-column matrix (or object coercible to one) with
dimension/degree, start/birth and end/death columns; if it has only 2
columns, we assume that the \code{dimension} column is missing and we set it to
\code{0} (i.e. we assume that the data is in the form \code{birth} and \code{death}),
\item a \code{\link[base:data.frame]{base::data.frame}} (or object coercible to one) with at least 3 columns
containing the persistence data; if it has only 2 columns, we assume that the
\code{dimension} column is missing and we set it to \code{0},
\item a list of 2-column matrices (or objects coercible to one) with the first column
being the birth and the second column being the death of homological
features; indexed by dimension, i.e. the \eqn{i}-\emph{th} element of the list
corresponds to the \eqn{(i-1)}-\emph{th} homology dimension,
\item an object of class 'PHom' as returned by
\href{https://tdaverse.github.io/ripserr/reference/vietoris_rips.html}{\code{ripserr::vietoris_rips()}},
\item (a list as returned by a \verb{*Diag()} function in \strong{TDA} (e.g.
\href{https://www.rdocumentation.org/packages/TDA/versions/1.9.1/topics/ripsDiag}{\code{TDA::ripsDiag()}})
whose first element is) an object of class 'diagram',
\item an object of class \code{\link[stats:hclust]{stats::hclust}} in which case we use the entry \code{height}
as the death of homological features and 0 as the birth of all features.
}}

\item{warn}{A boolean specifying whether to issue a warning if the input
persistence data contained unordered pairs. Defaults to \code{TRUE}.}

\item{...}{Parameters passed to methods.}

\item{birth}{A numeric value specifying the height at which to declare all
leaves were born. Defaults to \code{0} if all heights are non-negative and
\code{-Inf} otherwise.}

\item{dimension}{A non-negative integer specifying the homology dimension for
which to recover a matrix of persistence pairs.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link[base]{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link[base]{data.frame}(*, check.names = !optional)}.
    See also the \code{make.names} argument of the \code{matrix} method.}
}
\value{
An object of class \code{\link{persistence}} which is a list of 2 elements:
\itemize{
\item \code{pairs}: A list of 2-column matrices containing birth-death pairs. The
\eqn{i}-\emph{th} element of the list corresponds to the \eqn{(i-1)}-\emph{th} homology
dimension. If there is no pairs for a given dimension but there are pairs in
higher dimensions, the corresponding element(s) is/are filled with a
\eqn{0 \times 2} numeric matrix.
\item \code{metadata}: A list of length 6 containing information about how the data
was computed:
\itemize{
\item \code{orderered_pairs}: A boolean indicating whether the pairs in the
\code{pairs} list are ordered (i.e. the first column is strictly less than the
second column).
\item \code{data}: The name of the object containing the original data on which the
persistence data was computed.
\item \code{engine}: The name of the package and the function of this package that
computed the persistence data in the form
\code{"package_name::package_function"}.
\item \code{filtration}: The filtration used in the computation in a human-readable
format (i.e. full names, capitals where need, etc.).
\item \code{parameters}: A list of parameters used in the computation.
\item \code{call}: The exact call that generated the persistence data.
}
}
}
\description{
A collection of functions to coerce persistence data into objects of class
\code{\link{persistence}} (See \strong{Value} section for more details on this class). It is
currently possible to coerce persistence data from the following sources:
\itemize{
\item a matrix with at least 3 columns (dimension/degree, start/birth, end/death)
as returned by
\href{https://tdaverse.github.io/ripserr/reference/vietoris_rips.html}{\code{ripserr::vietoris_rips()}}
in the form of the 'PHom' class,
\item a list as returned by any \verb{*Diag()} function in the \strong{TDA} package.
}
}
\details{
\strong{Caution.} When providing an \emph{unnamed} input matrix, the matrix coercer
assumes that it has at least 3 columns, with the first column being the
dimension/degree, the second column being the start/birth and the third
column being the end/death.
}
\examples{
as_persistence(noisy_circle_ripserr)

x <- as_persistence(noisy_circle_tda_rips)
x

as_persistence(x)

get_pairs(x, dimension = 1)

as.data.frame(x)

# distances between cities
euroclust <- hclust(eurodist, method = "ward.D")
as_persistence(euroclust)

# `hclust()` can accommodate negative distances
d <- as.dist(rbind(c(0, 3, -4), c(3, 0, 5), c(-4, 5, 0)))
hc <- hclust(d, method = "single")
ph <- as_persistence(hc, birth = -10)
get_pairs(ph, 0)
}
