% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distances}
\alias{distances}
\alias{bottleneck_distance}
\alias{wasserstein_distance}
\alias{kantorovich_distance}
\title{Distances between two persistence diagrams}
\usage{
bottleneck_distance(
  x,
  y,
  tol = sqrt(.Machine$double.eps),
  validate = TRUE,
  dimension = 0L
)

wasserstein_distance(
  x,
  y,
  tol = sqrt(.Machine$double.eps),
  p = 1,
  validate = TRUE,
  dimension = 0L
)

kantorovich_distance(
  x,
  y,
  tol = sqrt(.Machine$double.eps),
  p = 1,
  validate = TRUE,
  dimension = 0L
)
}
\arguments{
\item{x}{Either a matrix of shape \eqn{n \times 2} or an object of class
\link{persistence} specifying the first persistence diagram.}

\item{y}{Either a matrix of shape \eqn{m \times 2} or an object of class
\link{persistence} specifying the second persistence diagram.}

\item{tol}{A numeric value specifying the relative error. Defaults to
\code{sqrt(.Machine$double.eps)}. For the Bottleneck distance, it can be set to
\code{0.0} in which case the exact Bottleneck distance is computed, while an
approximate Bottleneck distance is computed if \code{tol > 0.0}. For the
Wasserstein distance, it must be strictly positive.}

\item{validate}{A boolean value specifying whether to validate the input
persistence diagrams. Defaults to \code{TRUE}. If \code{FALSE}, the function will not
check if the input persistence diagrams are valid. This can be useful for
performance reasons, but it is recommended to keep it \code{TRUE} for safety.}

\item{dimension}{An integer value specifying the homology dimension for which
to compute the distance. Defaults to \code{0L}. This is only used if \code{x} and \code{y}
are objects of class \link{persistence}.}

\item{p}{A numeric value specifying the power for the Wasserstein distance.
Defaults to \code{1.0}.}
}
\value{
A numeric value storing either the Bottleneck or the Wasserstein
distance between the two persistence diagrams.
}
\description{
This collection of functions computes the distance between two persistence
diagrams of the same homology dimension. The diagrams must be represented as
2-column matrices. The first column of the matrix contains the birth times
and the second column contains the death times of the points.
}
\details{
A matching \eqn{\varphi : D_1 \to D_2} between persistence diagrams is a
bijection of multisets, where both diagrams are assumed to have all points on
the diagonal with infinite multiplicity. The \emph{\eqn{p}-Wasserstein distance}
between \eqn{D_1} and \eqn{D_2} is defined as the infimum over all matchings
of the expression

\deqn{W_p(D_1,D_2) = \inf_{\varphi: D_1 \to D_2}
\left( \sum_{x \in D_1}{\lVert x - \varphi(x) \rVert^p}
\right)^{\frac{1}{p}}}

that can be thought of as the Minkowski distance between the diagrams viewed
as vectors on the shared coordinates defined by the matching \eqn{\varphi}.
The norm \eqn{\lVert \cdot \rVert} can be arbitrary; as implemented here, it
is the infinity norm \eqn{\lVert (x_1,x_2) \rVert_\infty = \max(x_1,x_2)}. In
the limit \eqn{p \to \infty}, the Wasserstein distance becomes the
\emph{bottleneck distance}:

\deqn{B(D_1,D_2) = \inf_{\varphi: D_1 \to D_2}
\sup_{x \in D_1}{\lVert x - \varphi(x) \rVert}.}

The Wasserstein metric is also called the Kantorovich metric in recognition
of the originator of the metric.
}
\examples{
bottleneck_distance(
  persistence_sample[[1]]$pairs[[1]],
  persistence_sample[[2]]$pairs[[1]]
)

bottleneck_distance(
  persistence_sample[[1]],
  persistence_sample[[2]]
)

wasserstein_distance(
  persistence_sample[[1]]$pairs[[1]],
  persistence_sample[[2]]$pairs[[1]]
)

wasserstein_distance(
  persistence_sample[[1]],
  persistence_sample[[2]]
)

}
\seealso{
\href{https://github.com/anigmetov/hera}{the Hera C++ library}
}
