% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dataset.R
\name{get_dataset}
\alias{get_dataset}
\title{Get Open Data resources from a dataset}
\usage{
get_dataset(
  dataset_name,
  max_resources = NULL,
  rows = NULL,
  row_filters = NULL,
  col_select = NULL,
  include_context = FALSE
)
}
\arguments{
\item{dataset_name}{Name of the dataset as found on the
\href{https://www.opendata.nhs.scot}{NHS Open Data platform} (character).}

\item{max_resources}{(optional) The maximum number of resources to return
(integer). If not set, all resources are returned.}

\item{rows}{(optional) Maximum number of rows to return (integer).}

\item{row_filters}{(optional) A named list or vector specifying values of columns/fields to keep (e.g., list(Date = 20220216, Sex = "Female")).}

\item{col_select}{(optional) A character vector containing the names of desired columns/fields (e.g., c("Date", "Sex")).}

\item{include_context}{(optional) If \code{TRUE}, additional information about the resource will be added as columns to the data, including the resource ID, the resource name, the creation date, and the last modified/updated date.}
}
\value{
A \link[tibble:tibble-package]{tibble} with the data.
}
\description{
Downloads multiple resources from a dataset on the NHS Open Data
platform by dataset name, with optional row limits and context columns.
}
\examples{
\dontshow{if (isTRUE(length(curl::nslookup("www.opendata.nhs.scot", error = FALSE)) > 0L)) withAutoprint(\{ # examplesIf}
\dontrun{
get_dataset("gp-practice-populations", max_resources = 2, rows = 10)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=get_resource]{get_resource()}} for downloading a single resource from a dataset.
}
