#' sepsis
#'
#' A fully synthetic data set with variables needed for examples and documentation
#' of the Phoenix Sepsis Criteria.
#'
#' @format a data.frame with 20 rows and 27 columns
#'
#' \tabular{rll}{
#' [,  1] \tab pid            \tab patient identification number                               \cr
#' [,  2] \tab age            \tab age in months                                               \cr
#' [,  3] \tab fio2           \tab fraction of inspired oxygen                                 \cr
#' [,  4] \tab pao2           \tab partial pressure of oxygen in arterial blood (mmHg)         \cr
#' [,  5] \tab spo2           \tab pulse oximetry                                              \cr
#' [,  6] \tab vent           \tab indicator for invasive mechanical ventilation               \cr
#' [,  7] \tab gcs_total      \tab total Glasgow Coma Scale                                    \cr
#' [,  8] \tab pupil          \tab character vector reporting if pupils are reactive or fixed. \cr
#' [,  9] \tab platelets      \tab platelets measured in 1,000 / microliter                    \cr
#' [, 10] \tab inr            \tab international normalized ratio                              \cr
#' [, 11] \tab d_dimer        \tab D-dimer; units of mg/L FEU                                  \cr
#' [, 12] \tab fibrinogen     \tab units of mg/dL                                              \cr
#' [, 13] \tab dbp            \tab diastolic blood pressure (mmHg)                             \cr
#' [, 14] \tab sbp            \tab systolic blood pressure (mmHg)                              \cr
#' [, 15] \tab lactate        \tab units of mmol/L                                             \cr
#' [, 16] \tab dobutamine     \tab indicator for receiving systemic dobutamine                 \cr
#' [, 17] \tab dopamine       \tab indicator for receiving systemic dopamine                   \cr
#' [, 18] \tab epinephrine    \tab indicator for receiving systemic epinephrine                \cr
#' [, 19] \tab milrinone      \tab indicator for receiving systemic milrinone                  \cr
#' [, 20] \tab norepinephrine \tab indicator for receiving systemic norepinephrine             \cr
#' [, 21] \tab vasopressin    \tab indicator for receiving systemic vasopressin                \cr
#' [, 22] \tab glucose        \tab units of mg/dL                                              \cr
#' [, 23] \tab anc            \tab units of 1,000 cells per cubic millimeter                   \cr
#' [, 24] \tab alc            \tab units of 1,000 cells per cubic millimeter                   \cr
#' [, 25] \tab creatinine     \tab units of mg/dL                                              \cr
#' [, 26] \tab bilirubin      \tab units of mg/dL                                              \cr
#' [, 27] \tab alt            \tab units of IU/L                                               \cr
#' }
"sepsis"
