% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tu_onco_recist.R
\docType{data}
\name{tu_onco_recist}
\alias{tu_onco_recist}
\title{Tumor Identification (RECIST 1.1) for Oncology}
\format{
A data frame with 16 columns:
\describe{
\item{DOMAIN}{Domain Abbreviation}
\item{STUDYID}{Study Identifier}
\item{USUBJID}{Unique Subject Identifier}
\item{VISIT}{Visit Name}
\item{VISITNUM}{Visit Number}
\item{TULOC}{Location of the Tumor/Lesion}
\item{TUTESTCD}{Tumor/Lesion ID Short Name}
\item{TUTEST}{Tumor/Lesion ID Test Name}
\item{TUORRES}{Tumor/Lesion ID Result}
\item{TUSTRESC}{Tumor/Lesion ID Result Std. Format}
\item{TUMETHOD}{Method of Identification}
\item{TULNKID}{Link ID}
\item{TUEVAL}{Evaluator}
\item{TUEVALID}{Evaluator Identifier}
\item{TUACPTFL}{Accepted Record Flag}
\item{TUSEQ}{Sequence Number}
}
}
\source{
Generated dataset.
}
\usage{
tu_onco_recist
}
\description{
A SDTM TU dataset using RECIST 1.1 intended for examples of ADaM dataset creation
}
\details{
Tumor Identification (RECIST 1.1) for Oncology

A SDTM TU dataset using RECIST 1.1 intended for examples of ADaM dataset creation

Contains a set of 1 unique Test Short Name and Test Name: \tabular{ll}{
\strong{TUTESTCD} \tab \strong{TUTEST} \cr
TUMIDENT \tab Tumor Identification
}
}
\author{
Stefan Bundfuss
}
\keyword{dataset}
\keyword{oncology}
