% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adis_vaccine.R
\docType{data}
\name{adis_vaccine}
\alias{adis_vaccine}
\title{Immunogenicity Specimen Assessments}
\format{
A data frame with 103 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ COUNTRY }{Country}
\item{ DOMAIN }{Domain Abbreviation}
\item{ RFSTDTC }{Subject Reference Start Date/Time}
\item{ RFENDTC }{Subject Reference End Date/Time}
\item{ RFXSTDTC }{Date/Time of First Study Treatment}
\item{ RFXENDTC }{Date/Time of Last Study Treatment}
\item{ RFPENDTC }{Date/Time of End of Participation}
\item{ DTHDTC }{Date/Time of Death}
\item{ DTHFL }{Subject Death Flag}
\item{ REGION1 }{Geographic Region 1}
\item{ BRTHDTC }{Date/Time of Birth}
\item{ DMDTC }{Date/Time of Collection}
\item{ DMDY }{Study Day of Collection}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ AGEGR1 }{Pooled Age Group 1}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ RACEGR1 }{Pooled Race Group 1}
\item{ ETHNIC }{Ethnicity}
\item{ SAFFL }{Safety Population Flag}
\item{ PPROTFL }{Per-Protocol Population Flag}
\item{ ARM }{Description of Planned Arm}
\item{ ARMCD }{Planned Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ TRTP }{Planned Treatment}
\item{ TRTA }{Actual Treatment}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRT02P }{Planned Treatment for Period 02}
\item{ TRT02A }{Actual Treatment for Period 02}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ AP01SDT }{Period 01 Start Date}
\item{ AP01EDT }{Period 01 End Date}
\item{ AP02SDT }{Period 02 Start Date}
\item{ AP02EDT }{Period 02 End Date}
\item{ APERSDT }{Period Start Date}
\item{ APEREDT }{Period End Date}
\item{ RFICDTC }{Date/Time of Informed Consent}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ ATPT }{Analysis Timepoint}
\item{ ATPTN }{Analysis Timepoint (N)}
\item{ ATPTREF }{Analysis Timepoint Reference}
\item{ APERIOD }{Period}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARAMN }{Parameter (N)}
\item{ PARCAT1 }{Parameter Category 1}
\item{ AVAL }{Analysis Value}
\item{ AVALU }{Analysis Value Unit}
\item{ BASE }{Baseline Value}
\item{ BASECAT1 }{Baseline Category 1}
\item{ BASETYPE }{Baseline Type}
\item{ CHG }{Change from Baseline}
\item{ R2BASE }{Ratio to Baseline}
\item{ CRIT1 }{Analysis Criterion 1}
\item{ CRIT1FL }{Criterion 1 Evaluation Result Flag}
\item{ CRIT1FN }{Criterion 1 Evaluation Result Flag (N)}
\item{ DTYPE }{Derivation Type}
\item{ ABLFL }{Baseline Record Flag}
\item{ ISSEQ }{Sequence Number}
\item{ ISTESTCD }{Immunogenicity Test/Exam Short Name}
\item{ ISTEST }{Immunogenicity Test or Examination Name}
\item{ ISCAT }{Category for Immunogenicity Test}
\item{ ISORRES }{Results or Findings in Original Units}
\item{ ISORRESU }{Original Units}
\item{ ISSTRESC }{Character Result/Finding in Std Format}
\item{ ISSTRESN }{Numeric Results/Findings in Std. Units}
\item{ ISSTRESU }{Standard Units}
\item{ ISSTAT }{Completion Status}
\item{ ISREASND }{Reason Not Done}
\item{ ISNAM }{Vendor Name}
\item{ ISSPEC }{Specimen Type}
\item{ ISMETHOD }{Method of Test or Examination}
\item{ ISBLFL }{Baseline Flag}
\item{ ISLLOQ }{Lower Limit of Quantitation}
\item{ VISITNUM }{Visit Number}
\item{ EPOCH }{Epoch}
\item{ ISDTC }{Date/Time of Collection}
\item{ ISDY }{Study Day of Visit/Collection/Exam}
\item{ ISULOQ }{Upper Limit of Quantitation}
\item{ LOD }{Limit of Detection}
\item{ DERIVED }{Derivation Method}
\item{ CUTOFF02 }{First Cutoff Value}
\item{ CUTOFF03 }{Second Cutoff Value}
\item{ SERCAT1 }{Pre-vaccination seropositivity status}
\item{ SERCAT1N }{Pre-vaccination sero status (n)}
\item{ PPSRFL }{Per-Protocol Record-Level Flag}
\item{ INVID }{Investigator Identifier}
\item{ INVNAM }{Investigator Name}
\item{ VAX01DT }{Vaccination Date 01}
\item{ VAX02DT }{Vaccination Date 02}
}
}
\source{
Generated from admiralvaccine package (template ad_adis.R).
}
\usage{
adis_vaccine
}
\description{
Immunogenicity Specimen Assessments
}
\details{
Contains a set of 16 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
I0019NLF \tab LOG10 4FOLD (I0019NT Antibody)\cr
I0019NT  \tab I0019NT Antibody              \cr
I0019NTF \tab 4FOLD (I0019NT Antibody)      \cr
I0019NTL \tab LOG10 (I0019NT Antibody)      \cr
J0033VLF \tab LOG10 4FOLD (J0033VN Antibody)\cr
J0033VN  \tab J0033VN Antibody              \cr
J0033VNF \tab 4FOLD (J0033VN Antibody)      \cr
J0033VNL \tab LOG10 (J0033VN Antibody)      \cr
M0019LLF \tab LOG10 4FOLD (M0019LN Antibody)\cr
M0019LN  \tab M0019LN Antibody              \cr
M0019LNF \tab 4FOLD (M0019LN Antibody)      \cr
M0019LNL \tab LOG10 (M0019LN Antibody)      \cr
R0003MA  \tab R0003MA Antibody              \cr
R0003MAF \tab 4FOLD (R0003MA Antibody)      \cr
R0003MAL \tab LOG10 (R0003MA Antibody)      \cr
R0003MLF \tab LOG10 4FOLD (R0003MA Antibody)
}
}
\examples{
data("adis_vaccine")
}
\references{
None
}
\keyword{dataset}
\keyword{vaccine}
