% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguOptimizer.R
\name{pgu.optimizer}
\alias{pgu.optimizer}
\title{pgu.optimizer}
\format{
[R6::R6Class] object.
}
\description{
Finds the transformation models that result in distributions that come closest to a normal distribution.
}
\details{
Analysis is performed individually on each attribute.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{features}}{Returns the instance variable features.
(character)}

\item{\code{trafoAlphabet}}{Returns the instance variable trafoAlphabet.
(character)}

\item{\code{setTrafoAlphabet}}{Sets the instance variable trafoAlphabet to data.
(character)}

\item{\code{mirror}}{Returns the instance variable mirror
(logical)}

\item{\code{setMirror}}{Sets the instance variable mirror to data
(logical)}

\item{\code{optParameter}}{Returns the instance variable optParameter
(tibble::tibble)}

\item{\code{optTypes}}{Returns the instance variable optTypes
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.optimizer-new}{\code{pgu.optimizer$new()}}
\item \href{#method-pgu.optimizer-finalize}{\code{pgu.optimizer$finalize()}}
\item \href{#method-pgu.optimizer-print}{\code{pgu.optimizer$print()}}
\item \href{#method-pgu.optimizer-resetFeatures}{\code{pgu.optimizer$resetFeatures()}}
\item \href{#method-pgu.optimizer-resetOptParameter}{\code{pgu.optimizer$resetOptParameter()}}
\item \href{#method-pgu.optimizer-resetOptTypes}{\code{pgu.optimizer$resetOptTypes()}}
\item \href{#method-pgu.optimizer-resetOptimizer}{\code{pgu.optimizer$resetOptimizer()}}
\item \href{#method-pgu.optimizer-featureIdx}{\code{pgu.optimizer$featureIdx()}}
\item \href{#method-pgu.optimizer-modelParameterIsBigger}{\code{pgu.optimizer$modelParameterIsBigger()}}
\item \href{#method-pgu.optimizer-modelParameterIsSmaller}{\code{pgu.optimizer$modelParameterIsSmaller()}}
\item \href{#method-pgu.optimizer-updateTrafoType}{\code{pgu.optimizer$updateTrafoType()}}
\item \href{#method-pgu.optimizer-updateMirrorLogic}{\code{pgu.optimizer$updateMirrorLogic()}}
\item \href{#method-pgu.optimizer-updateOptParameter}{\code{pgu.optimizer$updateOptParameter()}}
\item \href{#method-pgu.optimizer-optimize}{\code{pgu.optimizer$optimize()}}
\item \href{#method-pgu.optimizer-trafoAlpahbetTblDf}{\code{pgu.optimizer$trafoAlpahbetTblDf()}}
\item \href{#method-pgu.optimizer-clone}{\code{pgu.optimizer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.optimizer` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$new(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `pgu.optimizer` object.
(pguIMP::pgu.optimizer)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of `pgu.optimizer` is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.optimizer` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-resetFeatures"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-resetFeatures}{}}}
\subsection{Method \code{resetFeatures()}}{
Extract the attribute names from the given data frame
and stores them in the class' instance variable
features,
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$resetFeatures(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-resetOptParameter"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-resetOptParameter}{}}}
\subsection{Method \code{resetOptParameter()}}{
Initializes the instance variable optParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$resetOptParameter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-resetOptTypes"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-resetOptTypes}{}}}
\subsection{Method \code{resetOptTypes()}}{
Initializes the instance variable optTypes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$resetOptTypes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-resetOptimizer"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-resetOptimizer}{}}}
\subsection{Method \code{resetOptimizer()}}{
Initializes the optimizer instance variables.
Here, initialization defines a consecutive sequence of the class' functions:
resetFeatures, setTrafoAlphabet, setMirror, resetOptParameter and resetOptTypes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$resetOptimizer(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-featureIdx"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-featureIdx}{}}}
\subsection{Method \code{featureIdx()}}{
Determines the numerical index of the column of an attribute based on the attribute name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$featureIdx(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{The attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The attributes column index.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-modelParameterIsBigger"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-modelParameterIsBigger}{}}}
\subsection{Method \code{modelParameterIsBigger()}}{
Compares a model parameter to a reference parameter and tests, if the model parameter is bigger.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$modelParameterIsBigger(
  modelParameter = "numeric",
  referenceParameter = "numeric"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{modelParameter}}{The model parameter
(numeric)}

\item{\code{referenceParameter}}{The reference parameter
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Test Result
(logical)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-modelParameterIsSmaller"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-modelParameterIsSmaller}{}}}
\subsection{Method \code{modelParameterIsSmaller()}}{
Compares a model parameter to a reference parameter and tests, if the model parameter is smaller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$modelParameterIsSmaller(
  modelParameter = "numeric",
  referenceParameter = "numeric"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{modelParameter}}{The model parameter
(numeric)}

\item{\code{referenceParameter}}{The reference parameter
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Test Result
(logical)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-updateTrafoType"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-updateTrafoType}{}}}
\subsection{Method \code{updateTrafoType()}}{
Takes an instance of the pgu.transfromator class and
sets the transformation type to a user defined value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$updateTrafoType(
  transformator = "pgu.transformator",
  type = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformator}}{An instance of the pgu.transformator class
(pguIMP::pgu.transformator)}

\item{\code{type}}{A transfromation type
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An updated instance of the pgu.transformator class
(pguIMP::pgu.transformator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-updateMirrorLogic"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-updateMirrorLogic}{}}}
\subsection{Method \code{updateMirrorLogic()}}{
Takes an instance of the pgu.transfromator class and
sets the mirrorLogic parameter to a user defined value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$updateMirrorLogic(
  transformator = "pgu.transformator",
  logic = "logical"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformator}}{An instance of the pgu.transformator class
(pguIMP::pgu.transformator)}

\item{\code{logic}}{The mirrorLogic parameter
(logic)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An updated instance of the pgu.transformator class
(pguIMP::pgu.transformator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-updateOptParameter"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-updateOptParameter}{}}}
\subsection{Method \code{updateOptParameter()}}{
Takes an instance of the pgu.model class and analyzes it.
Keeps track of the optimal model parameters during optimization
and stores them in the instance variables optTypes and optParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$updateOptParameter(
  model = "pgu.model",
  type = "character",
  logic = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{An instance of the pgu.model class
(pguIMP::pgu.model)}

\item{\code{type}}{A transfromation type
(character)}

\item{\code{logic}}{The mirrorLogic parameter
(logic)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-optimize}{}}}
\subsection{Method \code{optimize()}}{
Permutates all possible variations of data transfromations and iterates through them.
Analysis the optimal transformation parameters for each attribute in the data frame and stores them
in the instance variables optParameter, optTypes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$optimize(data = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-trafoAlpahbetTblDf"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-trafoAlpahbetTblDf}{}}}
\subsection{Method \code{trafoAlpahbetTblDf()}}{
Returns information on the optimization progress
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$trafoAlpahbetTblDf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The data frame comprizing analysis information.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.optimizer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.optimizer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.optimizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
