% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialCorrelationMatrix.R
\name{partialcor.table}
\alias{partialcor.table}
\title{Partial Correlation Matrix.}
\usage{
partialcor.table(
  x,
  y,
  z = NULL,
  type = "none",
  dig = 2,
  correlation = "pearson"
)
}
\arguments{
\item{x}{Variable or set of variables in the form of a vector or dataframe
to correlate with \code{y} (if \code{y} is specified) in an any asymmetric
correlation matrix or with itself in a symmetric correlation matrix (if
\code{y} is not specified).}

\item{y}{(optional) Variable or set of variables in the form of a vector or
dataframe to correlate with \code{x}.}

\item{z}{Covariate(s) to partial out from association.}

\item{type}{Type of correlation matrix to print. One of:
\itemize{
  \item \code{"none"} = correlation matrix with \emph{r}, \emph{n},
  \emph{p}-values
  \item \code{"latex"} = generates latex code for correlation matrix with only
  \emph{r}-values
  \item \code{"latexSPSS"} = generates latex code for full SPSS-style
  correlation matrix
  \item \code{"manuscript"} = only \emph{r}-values, 2 digits; works with
  \code{x} only (cannot enter variables for \code{y})
  \item \code{"manuscriptBig"} = only \emph{r}-values, 2 digits, no asterisks;
  works with \code{x} only (cannot enter variables for \code{y})
  \item \code{"manuscriptLatex"} = generates latex code for: only
  \emph{r}-values, 2 digits; works with \code{x} only (cannot enter variables
  for \code{y})
  \item \code{"manuscriptBigLatex"} = generates latex code for: only
  \emph{r}-values, 2 digits, no asterisks; works with \code{x} only (cannot
  enter variables for \code{x})
}}

\item{dig}{Number of decimals to print.}

\item{correlation}{Method for calculating the association. One of:
\itemize{
  \item \code{"pearson"} = Pearson product moment correlation coefficient
  \item \code{"spearman"} = Spearman's rho
  \item \code{"kendall"} = Kendall's tau
}}
}
\value{
A partial correlation matrix.
}
\description{
Function that creates a partial correlation matrix similar to SPSS output.
}
\details{
Co-created by Angela Staples (astaples@emich.edu) and Isaac Petersen
(isaac-t-petersen@uiowa.edu). Creates a partial correlation matrix,
controlling for one or more covariates. For a standard correlation matrix,
see \link{cor.table}.
}
\examples{
# Prepare Data
data("mtcars")

#Correlation Matrix
partialcor.table(mtcars[,c("mpg","cyl","disp")], z = mtcars$hp)
partialcor.table(mtcars[,c("mpg","cyl","disp")], z = mtcars[,c("hp","wt")])
partialcor.table(mtcars[,c("mpg","cyl","disp")], z = mtcars[,c("hp","wt")],
  dig = 3)
partialcor.table(mtcars[,c("mpg","cyl","disp")], z = mtcars[,c("hp","wt")],
  dig = 3, correlation = "spearman")

partialcor.table(mtcars[,c("mpg","cyl","disp")], z = mtcars[,c("hp","wt")],
  type = "manuscript", dig = 3)
partialcor.table(mtcars[,c("mpg","cyl","disp")], z = mtcars[,c("hp","wt")],
  type = "manuscriptBig")

table1 <- partialcor.table(mtcars[,c("mpg","cyl","disp")],
  z = mtcars[,c("hp","wt")], type = "latex")
table2 <- partialcor.table(mtcars[,c("mpg","cyl","disp")],
  z = mtcars[,c("hp","wt")], type = "latexSPSS")
table3 <- partialcor.table(mtcars[,c("mpg","cyl","disp")],
  z = mtcars[,c("hp","wt")], type = "manuscriptLatex")
table4 <- partialcor.table(mtcars[,c("mpg","cyl","disp")],
  z = mtcars[,c("hp","wt")], type = "manuscriptBigLatex")

partialcor.table(mtcars[,c("mpg","cyl","disp")], mtcars[,c("drat","qsec")],
  mtcars[,c("hp","wt")])
partialcor.table(mtcars[,c("mpg","cyl","disp")], mtcars[,c("drat","qsec")],
  mtcars[,c("hp","wt")], type = "manuscript", dig = 3)
}
\seealso{
Other correlations: 
\code{\link{addText}()},
\code{\link{cor.table}()},
\code{\link{crossTimeCorrelation}()},
\code{\link{crossTimeCorrelationDF}()},
\code{\link{vwReg}()}
}
\concept{correlations}
