% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeStationary.R
\name{makeStationary}
\alias{makeStationary}
\title{Transformation (stabilisation) to stationarity}
\usage{
makeStationary(mutmat, afreq = NULL, method = "PM")
}
\arguments{
\item{mutmat}{A square mutation matrix; typically a \code{\link[=mutationMatrix]{mutationMatrix()}} or
\code{\link[=mutationModel]{mutationModel()}}.}

\item{afreq}{A vector of allele frequencies. Extracted from \code{mutmat} if not
provided.}

\item{method}{A character string indicating the method to use. Currently only
"PM" is implemented.}
}
\value{
An object of the same class the input \code{mutmat}; either a matrix, a
\code{mutationMatrix} or a \code{mutationModel}.
}
\description{
For a given mutation model \verb{(M,p)}, transform \code{M} into another mutation
matrix \code{S} such that \code{S} is stationary with respect to \code{p}. Several methods
for doing this are described by Simonsson and Mostad (2016); only the "PM"
method is included here.
}
\details{
These transformations may also be applied by setting \code{transform = "PM"} in
\code{\link[=mutationMatrix]{mutationMatrix()}} or \code{\link[=mutationModel]{mutationModel()}}.

For details about the transformation, see Simonsson and Mostad (2016).

This function is a slightly optimised version of the \code{stabilize()} method in
the Familias R package.
}
\examples{

afreq = c(`1` = .2, `2` = .3, `3` = .5)
m = mutationMatrix("step", afreq = afreq, rate=0.1, rate2=0.01, range=0.1)
m
makeStationary(m, afreq = c(.3,.3,.4))


### Example with full model (i.e., male and female)

M = mutationModel("equal", afreq = afreq, rate = list(male=0.1, female=0.2))
M
makeStationary(M)

}
\references{
Simonsson & Mostad (2016). \emph{Stationary mutation models}. Forensic
Sci. Int. Genet. 23:217–225. \doi{10.1016/j.fsigen.2016.04.005}
}
