% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylogenetic.R
\name{drop_tips_update}
\alias{drop_tips_update}
\title{Drop Tips and Update a Phylogenetic Tree}
\usage{
drop_tips_update(tr, drop_name, pattern = NULL)
}
\arguments{
\item{tr}{A phylogenetic tree of class \code{phylo}.}

\item{drop_name}{A character vector of tip or node names to drop.
If missing and \code{pattern} is provided, names matching the pattern will be dropped.}

\item{pattern}{An optional regular expression pattern to match tip or node labels for dropping.}
}
\value{
A \code{phylo} object with specified tips removed.
}
\description{
This function iteratively removes specified tips (or tips matching a pattern)
from a phylogenetic tree without collapsing internal nodes or singleton nodes.
}
\examples{
if (requireNamespace("ape")) {
  library(ape)
  tr <- rtree(10)
  plot(tr)
  # Drop tips containing "t1" or "t2" in their label
  tr2 <- drop_tips_update(tr, pattern = "t1|t2")
  plot(tr2)

  # Alternatively, specify tips directly
  tr3 <- drop_tips_update(tr, drop_name = c("t3", "t5"))
  plot(tr3)
}
}
