% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_update_recovery_point_index_settings}
\alias{backup_update_recovery_point_index_settings}
\title{This operation updates the settings of a recovery point index}
\usage{
backup_update_recovery_point_index_settings(
  BackupVaultName,
  RecoveryPointArn,
  IamRoleArn = NULL,
  Index
)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the Region where they are created.

Accepted characters include lowercase letters, numbers, and hyphens.}

\item{RecoveryPointArn}{[required] An ARN that uniquely identifies a recovery point; for example,
\verb{arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45}.}

\item{IamRoleArn}{This specifies the IAM role ARN used for this operation.

For example, arn:aws:iam::123456789012:role/S3Access}

\item{Index}{[required] Index can have 1 of 2 possible values, either \code{ENABLED} or \code{DISABLED}.

To create a backup index for an eligible \code{ACTIVE} recovery point that
does not yet have a backup index, set value to \code{ENABLED}.

To delete a backup index, set value to \code{DISABLED}.}
}
\description{
This operation updates the settings of a recovery point index.

See \url{https://www.paws-r-sdk.com/docs/backup_update_recovery_point_index_settings/} for full documentation.
}
\keyword{internal}
