% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscalingplans_operations.R
\name{autoscalingplans_get_scaling_plan_resource_forecast_data}
\alias{autoscalingplans_get_scaling_plan_resource_forecast_data}
\title{Retrieves the forecast data for a scalable resource}
\usage{
autoscalingplans_get_scaling_plan_resource_forecast_data(
  ScalingPlanName,
  ScalingPlanVersion,
  ServiceNamespace,
  ResourceId,
  ScalableDimension,
  ForecastDataType,
  StartTime,
  EndTime
)
}
\arguments{
\item{ScalingPlanName}{[required] The name of the scaling plan.}

\item{ScalingPlanVersion}{[required] The version number of the scaling plan. Currently, the only valid value
is \code{1}.}

\item{ServiceNamespace}{[required] The namespace of the AWS service. The only valid value is \code{autoscaling}.}

\item{ResourceId}{[required] The ID of the resource. This string consists of a prefix
(\code{autoScalingGroup}) followed by the name of a specified Auto Scaling
group (\code{my-asg}). Example: \code{autoScalingGroup/my-asg}.}

\item{ScalableDimension}{[required] The scalable dimension for the resource. The only valid value is
\code{autoscaling:autoScalingGroup:DesiredCapacity}.}

\item{ForecastDataType}{[required] The type of forecast data to get.
\itemize{
\item \code{LoadForecast}: The load metric forecast.
\item \code{CapacityForecast}: The capacity forecast.
\item \code{ScheduledActionMinCapacity}: The minimum capacity for each
scheduled scaling action. This data is calculated as the larger of
two values: the capacity forecast or the minimum capacity in the
scaling instruction.
\item \code{ScheduledActionMaxCapacity}: The maximum capacity for each
scheduled scaling action. The calculation used is determined by the
predictive scaling maximum capacity behavior setting in the scaling
instruction.
}}

\item{StartTime}{[required] The inclusive start time of the time range for the forecast data to get.
The date and time can be at most 56 days before the current date and
time.}

\item{EndTime}{[required] The exclusive end time of the time range for the forecast data to get.
The maximum time duration between the start and end time is seven days.

Although this parameter can accept a date and time that is more than two
days in the future, the availability of forecast data has limits. AWS
Auto Scaling only issues forecasts for periods of two days in advance.}
}
\description{
Retrieves the forecast data for a scalable resource.

See \url{https://www.paws-r-sdk.com/docs/autoscalingplans_get_scaling_plan_resource_forecast_data/} for full documentation.
}
\keyword{internal}
