% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_send_outbound_email}
\alias{connect_send_outbound_email}
\title{Send outbound email for outbound campaigns}
\usage{
connect_send_outbound_email(
  InstanceId,
  FromEmailAddress,
  DestinationEmailAddress,
  AdditionalRecipients = NULL,
  EmailMessage,
  TrafficType,
  SourceCampaign = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{FromEmailAddress}{[required] The email address to be used for sending email.}

\item{DestinationEmailAddress}{[required] The email address to send the email to.}

\item{AdditionalRecipients}{The additional recipients address of the email in CC.}

\item{EmailMessage}{[required] The email message body to be sent to the newly created email.}

\item{TrafficType}{[required] Denotes the class of traffic.}

\item{SourceCampaign}{A Campaign object need for Campaign traffic type.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Send outbound email for outbound campaigns. For more information about outbound campaigns, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html}{Set up Amazon Connect outbound campaigns}.

See \url{https://www.paws-r-sdk.com/docs/connect_send_outbound_email/} for full documentation.
}
\keyword{internal}
