# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include connectwisdomservice_service.R
NULL

#' Creates an Amazon Connect Wisdom assistant
#'
#' @description
#' Creates an Amazon Connect Wisdom assistant.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_create_assistant/](https://www.paws-r-sdk.com/docs/connectwisdomservice_create_assistant/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param description The description of the assistant.
#' @param name &#91;required&#93; The name of the assistant.
#' @param serverSideEncryptionConfiguration The configuration information for the customer managed key used for
#' encryption.
#' 
#' The customer managed key must have a policy that allows
#' `kms:CreateGrant`, ` kms:DescribeKey`, and
#' `kms:Decrypt/kms:GenerateDataKey` permissions to the IAM identity using
#' the key to invoke Wisdom. To use Wisdom with chat, the key policy must
#' also allow `kms:Decrypt`, `kms:GenerateDataKey*`, and `kms:DescribeKey`
#' permissions to the `connect.amazonaws.com` service principal.
#' 
#' For more information about setting up a customer managed key for Wisdom,
#' see [Enable Amazon Connect Wisdom for your
#' instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
#' @param tags The tags used to organize, track, or control access for this resource.
#' @param type &#91;required&#93; The type of assistant.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_create_assistant
connectwisdomservice_create_assistant <- function(clientToken = NULL, description = NULL, name, serverSideEncryptionConfiguration = NULL, tags = NULL, type) {
  op <- new_operation(
    name = "CreateAssistant",
    http_method = "POST",
    http_path = "/assistants",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$create_assistant_input(clientToken = clientToken, description = description, name = name, serverSideEncryptionConfiguration = serverSideEncryptionConfiguration, tags = tags, type = type)
  output <- .connectwisdomservice$create_assistant_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$create_assistant <- connectwisdomservice_create_assistant

#' Creates an association between an Amazon Connect Wisdom assistant and
#' another resource
#'
#' @description
#' Creates an association between an Amazon Connect Wisdom assistant and another resource. Currently, the only supported association is with a knowledge base. An assistant can have only a single association.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_create_assistant_association/](https://www.paws-r-sdk.com/docs/connectwisdomservice_create_assistant_association/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param association &#91;required&#93; The identifier of the associated resource.
#' @param associationType &#91;required&#93; The type of association.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_create_assistant_association
connectwisdomservice_create_assistant_association <- function(assistantId, association, associationType, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAssistantAssociation",
    http_method = "POST",
    http_path = "/assistants/{assistantId}/associations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$create_assistant_association_input(assistantId = assistantId, association = association, associationType = associationType, clientToken = clientToken, tags = tags)
  output <- .connectwisdomservice$create_assistant_association_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$create_assistant_association <- connectwisdomservice_create_assistant_association

#' Creates Wisdom content
#'
#' @description
#' Creates Wisdom content. Before to calling this API, use [`start_content_upload`][connectwisdomservice_start_content_upload] to upload an asset.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_create_content/](https://www.paws-r-sdk.com/docs/connectwisdomservice_create_content/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param metadata A key/value map to store attributes without affecting tagging or
#' recommendations. For example, when synchronizing data between an
#' external system and Wisdom, you can store an external version identifier
#' as metadata to utilize for determining drift.
#' @param name &#91;required&#93; The name of the content. Each piece of content in a knowledge base must
#' have a unique name. You can retrieve a piece of content using only its
#' knowledge base and its name with the
#' [`search_content`][connectwisdomservice_search_content] API.
#' @param overrideLinkOutUri The URI you want to use for the article. If the knowledge base has a
#' templateUri, setting this argument overrides it for this piece of
#' content.
#' @param tags The tags used to organize, track, or control access for this resource.
#' @param title The title of the content. If not set, the title is equal to the name.
#' @param uploadId &#91;required&#93; A pointer to the uploaded asset. This value is returned by
#' [`start_content_upload`][connectwisdomservice_start_content_upload].
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_create_content
connectwisdomservice_create_content <- function(clientToken = NULL, knowledgeBaseId, metadata = NULL, name, overrideLinkOutUri = NULL, tags = NULL, title = NULL, uploadId) {
  op <- new_operation(
    name = "CreateContent",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/contents",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$create_content_input(clientToken = clientToken, knowledgeBaseId = knowledgeBaseId, metadata = metadata, name = name, overrideLinkOutUri = overrideLinkOutUri, tags = tags, title = title, uploadId = uploadId)
  output <- .connectwisdomservice$create_content_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$create_content <- connectwisdomservice_create_content

#' Creates a knowledge base
#'
#' @description
#' Creates a knowledge base.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_create_knowledge_base/](https://www.paws-r-sdk.com/docs/connectwisdomservice_create_knowledge_base/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param description The description.
#' @param knowledgeBaseType &#91;required&#93; The type of knowledge base. Only CUSTOM knowledge bases allow you to
#' upload your own content. EXTERNAL knowledge bases support integrations
#' with third-party systems whose content is synchronized automatically.
#' @param name &#91;required&#93; The name of the knowledge base.
#' @param renderingConfiguration Information about how to render the content.
#' @param serverSideEncryptionConfiguration The configuration information for the customer managed key used for
#' encryption.
#' 
#' This KMS key must have a policy that allows `kms:CreateGrant`,
#' `kms:DescribeKey`, and `kms:Decrypt/kms:GenerateDataKey` permissions to
#' the IAM identity using the key to invoke Wisdom.
#' 
#' For more information about setting up a customer managed key for Wisdom,
#' see [Enable Amazon Connect Wisdom for your
#' instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
#' @param sourceConfiguration The source of the knowledge base content. Only set this argument for
#' EXTERNAL knowledge bases.
#' @param tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_create_knowledge_base
connectwisdomservice_create_knowledge_base <- function(clientToken = NULL, description = NULL, knowledgeBaseType, name, renderingConfiguration = NULL, serverSideEncryptionConfiguration = NULL, sourceConfiguration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateKnowledgeBase",
    http_method = "POST",
    http_path = "/knowledgeBases",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$create_knowledge_base_input(clientToken = clientToken, description = description, knowledgeBaseType = knowledgeBaseType, name = name, renderingConfiguration = renderingConfiguration, serverSideEncryptionConfiguration = serverSideEncryptionConfiguration, sourceConfiguration = sourceConfiguration, tags = tags)
  output <- .connectwisdomservice$create_knowledge_base_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$create_knowledge_base <- connectwisdomservice_create_knowledge_base

#' Creates a Wisdom quick response
#'
#' @description
#' Creates a Wisdom quick response.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_create_quick_response/](https://www.paws-r-sdk.com/docs/connectwisdomservice_create_quick_response/) for full documentation.
#'
#' @param channels The Amazon Connect channels this quick response applies to.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param content &#91;required&#93; The content of the quick response.
#' @param contentType The media type of the quick response content.
#' 
#' -   Use `application/x.quickresponse;format=plain` for a quick response
#'     written in plain text.
#' 
#' -   Use `application/x.quickresponse;format=markdown` for a quick
#'     response written in richtext.
#' @param description The description of the quick response.
#' @param groupingConfiguration The configuration information of the user groups that the quick response
#' is accessible to.
#' @param isActive Whether the quick response is active.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param language The language code value for the language in which the quick response is
#' written. The supported language codes include `de_DE`, `en_US`, `es_ES`,
#' `fr_FR`, `id_ID`, `it_IT`, `ja_JP`, `ko_KR`, `pt_BR`, `zh_CN`, `zh_TW`
#' @param name &#91;required&#93; The name of the quick response.
#' @param shortcutKey The shortcut key of the quick response. The value should be unique
#' across the knowledge base.
#' @param tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_create_quick_response
connectwisdomservice_create_quick_response <- function(channels = NULL, clientToken = NULL, content, contentType = NULL, description = NULL, groupingConfiguration = NULL, isActive = NULL, knowledgeBaseId, language = NULL, name, shortcutKey = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateQuickResponse",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/quickResponses",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$create_quick_response_input(channels = channels, clientToken = clientToken, content = content, contentType = contentType, description = description, groupingConfiguration = groupingConfiguration, isActive = isActive, knowledgeBaseId = knowledgeBaseId, language = language, name = name, shortcutKey = shortcutKey, tags = tags)
  output <- .connectwisdomservice$create_quick_response_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$create_quick_response <- connectwisdomservice_create_quick_response

#' Creates a session
#'
#' @description
#' Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect creates a new Wisdom session for each contact on which Wisdom is enabled.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_create_session/](https://www.paws-r-sdk.com/docs/connectwisdomservice_create_session/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param description The description.
#' @param name &#91;required&#93; The name of the session.
#' @param tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_create_session
connectwisdomservice_create_session <- function(assistantId, clientToken = NULL, description = NULL, name, tags = NULL) {
  op <- new_operation(
    name = "CreateSession",
    http_method = "POST",
    http_path = "/assistants/{assistantId}/sessions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$create_session_input(assistantId = assistantId, clientToken = clientToken, description = description, name = name, tags = tags)
  output <- .connectwisdomservice$create_session_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$create_session <- connectwisdomservice_create_session

#' Deletes an assistant
#'
#' @description
#' Deletes an assistant.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_assistant/](https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_assistant/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_delete_assistant
connectwisdomservice_delete_assistant <- function(assistantId) {
  op <- new_operation(
    name = "DeleteAssistant",
    http_method = "DELETE",
    http_path = "/assistants/{assistantId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$delete_assistant_input(assistantId = assistantId)
  output <- .connectwisdomservice$delete_assistant_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$delete_assistant <- connectwisdomservice_delete_assistant

#' Deletes an assistant association
#'
#' @description
#' Deletes an assistant association.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_assistant_association/](https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_assistant_association/) for full documentation.
#'
#' @param assistantAssociationId &#91;required&#93; The identifier of the assistant association. Can be either the ID or the
#' ARN. URLs cannot contain the ARN.
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_delete_assistant_association
connectwisdomservice_delete_assistant_association <- function(assistantAssociationId, assistantId) {
  op <- new_operation(
    name = "DeleteAssistantAssociation",
    http_method = "DELETE",
    http_path = "/assistants/{assistantId}/associations/{assistantAssociationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$delete_assistant_association_input(assistantAssociationId = assistantAssociationId, assistantId = assistantId)
  output <- .connectwisdomservice$delete_assistant_association_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$delete_assistant_association <- connectwisdomservice_delete_assistant_association

#' Deletes the content
#'
#' @description
#' Deletes the content.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_content/](https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_content/) for full documentation.
#'
#' @param contentId &#91;required&#93; The identifier of the content. Can be either the ID or the ARN. URLs
#' cannot contain the ARN.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_delete_content
connectwisdomservice_delete_content <- function(contentId, knowledgeBaseId) {
  op <- new_operation(
    name = "DeleteContent",
    http_method = "DELETE",
    http_path = "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$delete_content_input(contentId = contentId, knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$delete_content_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$delete_content <- connectwisdomservice_delete_content

#' Deletes the quick response import job
#'
#' @description
#' Deletes the quick response import job.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_import_job/](https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_import_job/) for full documentation.
#'
#' @param importJobId &#91;required&#93; The identifier of the import job to be deleted.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_delete_import_job
connectwisdomservice_delete_import_job <- function(importJobId, knowledgeBaseId) {
  op <- new_operation(
    name = "DeleteImportJob",
    http_method = "DELETE",
    http_path = "/knowledgeBases/{knowledgeBaseId}/importJobs/{importJobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$delete_import_job_input(importJobId = importJobId, knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$delete_import_job_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$delete_import_job <- connectwisdomservice_delete_import_job

#' Deletes the knowledge base
#'
#' @description
#' Deletes the knowledge base.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_knowledge_base/](https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_knowledge_base/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The knowledge base to delete content from. Can be either the ID or the
#' ARN. URLs cannot contain the ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_delete_knowledge_base
connectwisdomservice_delete_knowledge_base <- function(knowledgeBaseId) {
  op <- new_operation(
    name = "DeleteKnowledgeBase",
    http_method = "DELETE",
    http_path = "/knowledgeBases/{knowledgeBaseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$delete_knowledge_base_input(knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$delete_knowledge_base_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$delete_knowledge_base <- connectwisdomservice_delete_knowledge_base

#' Deletes a quick response
#'
#' @description
#' Deletes a quick response.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_quick_response/](https://www.paws-r-sdk.com/docs/connectwisdomservice_delete_quick_response/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The knowledge base from which the quick response is deleted. The
#' identifier of the knowledge base. This should not be a QUICK_RESPONSES
#' type knowledge base if you're storing Wisdom Content resource to it.
#' @param quickResponseId &#91;required&#93; The identifier of the quick response to delete.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_delete_quick_response
connectwisdomservice_delete_quick_response <- function(knowledgeBaseId, quickResponseId) {
  op <- new_operation(
    name = "DeleteQuickResponse",
    http_method = "DELETE",
    http_path = "/knowledgeBases/{knowledgeBaseId}/quickResponses/{quickResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$delete_quick_response_input(knowledgeBaseId = knowledgeBaseId, quickResponseId = quickResponseId)
  output <- .connectwisdomservice$delete_quick_response_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$delete_quick_response <- connectwisdomservice_delete_quick_response

#' Retrieves information about an assistant
#'
#' @description
#' Retrieves information about an assistant.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_assistant/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_assistant/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_assistant
connectwisdomservice_get_assistant <- function(assistantId) {
  op <- new_operation(
    name = "GetAssistant",
    http_method = "GET",
    http_path = "/assistants/{assistantId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_assistant_input(assistantId = assistantId)
  output <- .connectwisdomservice$get_assistant_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_assistant <- connectwisdomservice_get_assistant

#' Retrieves information about an assistant association
#'
#' @description
#' Retrieves information about an assistant association.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_assistant_association/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_assistant_association/) for full documentation.
#'
#' @param assistantAssociationId &#91;required&#93; The identifier of the assistant association. Can be either the ID or the
#' ARN. URLs cannot contain the ARN.
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_assistant_association
connectwisdomservice_get_assistant_association <- function(assistantAssociationId, assistantId) {
  op <- new_operation(
    name = "GetAssistantAssociation",
    http_method = "GET",
    http_path = "/assistants/{assistantId}/associations/{assistantAssociationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_assistant_association_input(assistantAssociationId = assistantAssociationId, assistantId = assistantId)
  output <- .connectwisdomservice$get_assistant_association_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_assistant_association <- connectwisdomservice_get_assistant_association

#' Retrieves content, including a pre-signed URL to download the content
#'
#' @description
#' Retrieves content, including a pre-signed URL to download the content.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_content/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_content/) for full documentation.
#'
#' @param contentId &#91;required&#93; The identifier of the content. Can be either the ID or the ARN. URLs
#' cannot contain the ARN.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_content
connectwisdomservice_get_content <- function(contentId, knowledgeBaseId) {
  op <- new_operation(
    name = "GetContent",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_content_input(contentId = contentId, knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$get_content_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_content <- connectwisdomservice_get_content

#' Retrieves summary information about the content
#'
#' @description
#' Retrieves summary information about the content.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_content_summary/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_content_summary/) for full documentation.
#'
#' @param contentId &#91;required&#93; The identifier of the content. Can be either the ID or the ARN. URLs
#' cannot contain the ARN.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_content_summary
connectwisdomservice_get_content_summary <- function(contentId, knowledgeBaseId) {
  op <- new_operation(
    name = "GetContentSummary",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}/summary",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_content_summary_input(contentId = contentId, knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$get_content_summary_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_content_summary <- connectwisdomservice_get_content_summary

#' Retrieves the started import job
#'
#' @description
#' Retrieves the started import job.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_import_job/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_import_job/) for full documentation.
#'
#' @param importJobId &#91;required&#93; The identifier of the import job to retrieve.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base that the import job belongs to.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_import_job
connectwisdomservice_get_import_job <- function(importJobId, knowledgeBaseId) {
  op <- new_operation(
    name = "GetImportJob",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}/importJobs/{importJobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_import_job_input(importJobId = importJobId, knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$get_import_job_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_import_job <- connectwisdomservice_get_import_job

#' Retrieves information about the knowledge base
#'
#' @description
#' Retrieves information about the knowledge base.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_knowledge_base/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_knowledge_base/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_knowledge_base
connectwisdomservice_get_knowledge_base <- function(knowledgeBaseId) {
  op <- new_operation(
    name = "GetKnowledgeBase",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_knowledge_base_input(knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$get_knowledge_base_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_knowledge_base <- connectwisdomservice_get_knowledge_base

#' Retrieves the quick response
#'
#' @description
#' Retrieves the quick response.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_quick_response/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_quick_response/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should be a QUICK_RESPONSES
#' type knowledge base.
#' @param quickResponseId &#91;required&#93; The identifier of the quick response.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_quick_response
connectwisdomservice_get_quick_response <- function(knowledgeBaseId, quickResponseId) {
  op <- new_operation(
    name = "GetQuickResponse",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}/quickResponses/{quickResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_quick_response_input(knowledgeBaseId = knowledgeBaseId, quickResponseId = quickResponseId)
  output <- .connectwisdomservice$get_quick_response_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_quick_response <- connectwisdomservice_get_quick_response

#' Retrieves recommendations for the specified session
#'
#' @description
#' Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent calls, use [`notify_recommendations_received`][connectwisdomservice_notify_recommendations_received]. This API supports long-polling behavior with the `waitTimeSeconds` parameter. Short poll is the default behavior and only returns recommendations already available. To perform a manual query against an assistant, use [`query_assistant`][connectwisdomservice_query_assistant].
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_recommendations/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_recommendations/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param sessionId &#91;required&#93; The identifier of the session. Can be either the ID or the ARN. URLs
#' cannot contain the ARN.
#' @param waitTimeSeconds The duration (in seconds) for which the call waits for a recommendation
#' to be made available before returning. If a recommendation is available,
#' the call returns sooner than `WaitTimeSeconds`. If no messages are
#' available and the wait time expires, the call returns successfully with
#' an empty list.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_recommendations
connectwisdomservice_get_recommendations <- function(assistantId, maxResults = NULL, sessionId, waitTimeSeconds = NULL) {
  op <- new_operation(
    name = "GetRecommendations",
    http_method = "GET",
    http_path = "/assistants/{assistantId}/sessions/{sessionId}/recommendations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_recommendations_input(assistantId = assistantId, maxResults = maxResults, sessionId = sessionId, waitTimeSeconds = waitTimeSeconds)
  output <- .connectwisdomservice$get_recommendations_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_recommendations <- connectwisdomservice_get_recommendations

#' Retrieves information for a specified session
#'
#' @description
#' Retrieves information for a specified session.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_get_session/](https://www.paws-r-sdk.com/docs/connectwisdomservice_get_session/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param sessionId &#91;required&#93; The identifier of the session. Can be either the ID or the ARN. URLs
#' cannot contain the ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_get_session
connectwisdomservice_get_session <- function(assistantId, sessionId) {
  op <- new_operation(
    name = "GetSession",
    http_method = "GET",
    http_path = "/assistants/{assistantId}/sessions/{sessionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$get_session_input(assistantId = assistantId, sessionId = sessionId)
  output <- .connectwisdomservice$get_session_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$get_session <- connectwisdomservice_get_session

#' Lists information about assistant associations
#'
#' @description
#' Lists information about assistant associations.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_list_assistant_associations/](https://www.paws-r-sdk.com/docs/connectwisdomservice_list_assistant_associations/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_list_assistant_associations
connectwisdomservice_list_assistant_associations <- function(assistantId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAssistantAssociations",
    http_method = "GET",
    http_path = "/assistants/{assistantId}/associations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "assistantAssociationSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$list_assistant_associations_input(assistantId = assistantId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectwisdomservice$list_assistant_associations_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$list_assistant_associations <- connectwisdomservice_list_assistant_associations

#' Lists information about assistants
#'
#' @description
#' Lists information about assistants.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_list_assistants/](https://www.paws-r-sdk.com/docs/connectwisdomservice_list_assistants/) for full documentation.
#'
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_list_assistants
connectwisdomservice_list_assistants <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAssistants",
    http_method = "GET",
    http_path = "/assistants",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "assistantSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$list_assistants_input(maxResults = maxResults, nextToken = nextToken)
  output <- .connectwisdomservice$list_assistants_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$list_assistants <- connectwisdomservice_list_assistants

#' Lists the content
#'
#' @description
#' Lists the content.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_list_contents/](https://www.paws-r-sdk.com/docs/connectwisdomservice_list_contents/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_list_contents
connectwisdomservice_list_contents <- function(knowledgeBaseId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListContents",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}/contents",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "contentSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$list_contents_input(knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectwisdomservice$list_contents_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$list_contents <- connectwisdomservice_list_contents

#' Lists information about import jobs
#'
#' @description
#' Lists information about import jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_list_import_jobs/](https://www.paws-r-sdk.com/docs/connectwisdomservice_list_import_jobs/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_list_import_jobs
connectwisdomservice_list_import_jobs <- function(knowledgeBaseId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListImportJobs",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}/importJobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "importJobSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$list_import_jobs_input(knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectwisdomservice$list_import_jobs_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$list_import_jobs <- connectwisdomservice_list_import_jobs

#' Lists the knowledge bases
#'
#' @description
#' Lists the knowledge bases.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_list_knowledge_bases/](https://www.paws-r-sdk.com/docs/connectwisdomservice_list_knowledge_bases/) for full documentation.
#'
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_list_knowledge_bases
connectwisdomservice_list_knowledge_bases <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListKnowledgeBases",
    http_method = "GET",
    http_path = "/knowledgeBases",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "knowledgeBaseSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$list_knowledge_bases_input(maxResults = maxResults, nextToken = nextToken)
  output <- .connectwisdomservice$list_knowledge_bases_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$list_knowledge_bases <- connectwisdomservice_list_knowledge_bases

#' Lists information about quick response
#'
#' @description
#' Lists information about quick response.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_list_quick_responses/](https://www.paws-r-sdk.com/docs/connectwisdomservice_list_quick_responses/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_list_quick_responses
connectwisdomservice_list_quick_responses <- function(knowledgeBaseId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListQuickResponses",
    http_method = "GET",
    http_path = "/knowledgeBases/{knowledgeBaseId}/quickResponses",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "quickResponseSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$list_quick_responses_input(knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectwisdomservice$list_quick_responses_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$list_quick_responses <- connectwisdomservice_list_quick_responses

#' Lists the tags for the specified resource
#'
#' @description
#' Lists the tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/connectwisdomservice_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_list_tags_for_resource
connectwisdomservice_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .connectwisdomservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$list_tags_for_resource <- connectwisdomservice_list_tags_for_resource

#' Removes the specified recommendations from the specified assistant's
#' queue of newly available recommendations
#'
#' @description
#' Removes the specified recommendations from the specified assistant's queue of newly available recommendations. You can use this API in conjunction with [`get_recommendations`][connectwisdomservice_get_recommendations] and a `waitTimeSeconds` input for long-polling behavior and avoiding duplicate recommendations.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_notify_recommendations_received/](https://www.paws-r-sdk.com/docs/connectwisdomservice_notify_recommendations_received/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param recommendationIds &#91;required&#93; The identifiers of the recommendations.
#' @param sessionId &#91;required&#93; The identifier of the session. Can be either the ID or the ARN. URLs
#' cannot contain the ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_notify_recommendations_received
connectwisdomservice_notify_recommendations_received <- function(assistantId, recommendationIds, sessionId) {
  op <- new_operation(
    name = "NotifyRecommendationsReceived",
    http_method = "POST",
    http_path = "/assistants/{assistantId}/sessions/{sessionId}/recommendations/notify",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$notify_recommendations_received_input(assistantId = assistantId, recommendationIds = recommendationIds, sessionId = sessionId)
  output <- .connectwisdomservice$notify_recommendations_received_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$notify_recommendations_received <- connectwisdomservice_notify_recommendations_received

#' Performs a manual search against the specified assistant
#'
#' @description
#' Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use [`get_recommendations`][connectwisdomservice_get_recommendations].
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_query_assistant/](https://www.paws-r-sdk.com/docs/connectwisdomservice_query_assistant/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param queryText &#91;required&#93; The text to search for.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_query_assistant
connectwisdomservice_query_assistant <- function(assistantId, maxResults = NULL, nextToken = NULL, queryText) {
  op <- new_operation(
    name = "QueryAssistant",
    http_method = "POST",
    http_path = "/assistants/{assistantId}/query",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "results"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$query_assistant_input(assistantId = assistantId, maxResults = maxResults, nextToken = nextToken, queryText = queryText)
  output <- .connectwisdomservice$query_assistant_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$query_assistant <- connectwisdomservice_query_assistant

#' Removes a URI template from a knowledge base
#'
#' @description
#' Removes a URI template from a knowledge base.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_remove_knowledge_base_template_uri/](https://www.paws-r-sdk.com/docs/connectwisdomservice_remove_knowledge_base_template_uri/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_remove_knowledge_base_template_uri
connectwisdomservice_remove_knowledge_base_template_uri <- function(knowledgeBaseId) {
  op <- new_operation(
    name = "RemoveKnowledgeBaseTemplateUri",
    http_method = "DELETE",
    http_path = "/knowledgeBases/{knowledgeBaseId}/templateUri",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$remove_knowledge_base_template_uri_input(knowledgeBaseId = knowledgeBaseId)
  output <- .connectwisdomservice$remove_knowledge_base_template_uri_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$remove_knowledge_base_template_uri <- connectwisdomservice_remove_knowledge_base_template_uri

#' Searches for content in a specified knowledge base
#'
#' @description
#' Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_search_content/](https://www.paws-r-sdk.com/docs/connectwisdomservice_search_content/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param searchExpression &#91;required&#93; The search expression to filter results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_search_content
connectwisdomservice_search_content <- function(knowledgeBaseId, maxResults = NULL, nextToken = NULL, searchExpression) {
  op <- new_operation(
    name = "SearchContent",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/search",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "contentSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$search_content_input(knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken, searchExpression = searchExpression)
  output <- .connectwisdomservice$search_content_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$search_content <- connectwisdomservice_search_content

#' Searches existing Wisdom quick responses in a Wisdom knowledge base
#'
#' @description
#' Searches existing Wisdom quick responses in a Wisdom knowledge base.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_search_quick_responses/](https://www.paws-r-sdk.com/docs/connectwisdomservice_search_quick_responses/) for full documentation.
#'
#' @param attributes The [user-defined Amazon Connect contact
#' attributes](https://docs.aws.amazon.com/connect/latest/adminguide/connect-attrib-list.html#user-defined-attributes)
#' to be resolved when search results are returned.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should be a QUICK_RESPONSES
#' type knowledge base. Can be either the ID or the ARN. URLs cannot
#' contain the ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param searchExpression &#91;required&#93; The search expression for querying the quick response.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_search_quick_responses
connectwisdomservice_search_quick_responses <- function(attributes = NULL, knowledgeBaseId, maxResults = NULL, nextToken = NULL, searchExpression) {
  op <- new_operation(
    name = "SearchQuickResponses",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/search/quickResponses",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "results"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$search_quick_responses_input(attributes = attributes, knowledgeBaseId = knowledgeBaseId, maxResults = maxResults, nextToken = nextToken, searchExpression = searchExpression)
  output <- .connectwisdomservice$search_quick_responses_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$search_quick_responses <- connectwisdomservice_search_quick_responses

#' Searches for sessions
#'
#' @description
#' Searches for sessions.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_search_sessions/](https://www.paws-r-sdk.com/docs/connectwisdomservice_search_sessions/) for full documentation.
#'
#' @param assistantId &#91;required&#93; The identifier of the Wisdom assistant. Can be either the ID or the ARN.
#' URLs cannot contain the ARN.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param searchExpression &#91;required&#93; The search expression to filter results.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_search_sessions
connectwisdomservice_search_sessions <- function(assistantId, maxResults = NULL, nextToken = NULL, searchExpression) {
  op <- new_operation(
    name = "SearchSessions",
    http_method = "POST",
    http_path = "/assistants/{assistantId}/searchSessions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "sessionSummaries"),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$search_sessions_input(assistantId = assistantId, maxResults = maxResults, nextToken = nextToken, searchExpression = searchExpression)
  output <- .connectwisdomservice$search_sessions_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$search_sessions <- connectwisdomservice_search_sessions

#' Get a URL to upload content to a knowledge base
#'
#' @description
#' Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL with your file, making sure to include the required headers. Then use [`create_content`][connectwisdomservice_create_content] to finalize the content creation process or [`update_content`][connectwisdomservice_update_content] to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_start_content_upload/](https://www.paws-r-sdk.com/docs/connectwisdomservice_start_content_upload/) for full documentation.
#'
#' @param contentType &#91;required&#93; The type of content to upload.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param presignedUrlTimeToLive The expected expiration time of the generated presigned URL, specified
#' in minutes.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_start_content_upload
connectwisdomservice_start_content_upload <- function(contentType, knowledgeBaseId, presignedUrlTimeToLive = NULL) {
  op <- new_operation(
    name = "StartContentUpload",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/upload",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$start_content_upload_input(contentType = contentType, knowledgeBaseId = knowledgeBaseId, presignedUrlTimeToLive = presignedUrlTimeToLive)
  output <- .connectwisdomservice$start_content_upload_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$start_content_upload <- connectwisdomservice_start_content_upload

#' Start an asynchronous job to import Wisdom resources from an uploaded
#' source file
#'
#' @description
#' Start an asynchronous job to import Wisdom resources from an uploaded source file. Before calling this API, use [`start_content_upload`][connectwisdomservice_start_content_upload] to upload an asset that contains the resource data.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_start_import_job/](https://www.paws-r-sdk.com/docs/connectwisdomservice_start_import_job/) for full documentation.
#'
#' @param clientToken The tags used to organize, track, or control access for this resource.
#' @param externalSourceConfiguration The configuration information of the external source that the resource
#' data are imported from.
#' @param importJobType &#91;required&#93; The type of the import job.
#' 
#' -   For importing quick response resource, set the value to
#'     `QUICK_RESPONSES`.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' 
#' -   For importing Wisdom quick responses, this should be a
#'     `QUICK_RESPONSES` type knowledge base.
#' @param metadata The metadata fields of the imported Wisdom resources.
#' @param uploadId &#91;required&#93; A pointer to the uploaded asset. This value is returned by
#' [`start_content_upload`][connectwisdomservice_start_content_upload].
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_start_import_job
connectwisdomservice_start_import_job <- function(clientToken = NULL, externalSourceConfiguration = NULL, importJobType, knowledgeBaseId, metadata = NULL, uploadId) {
  op <- new_operation(
    name = "StartImportJob",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/importJobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$start_import_job_input(clientToken = clientToken, externalSourceConfiguration = externalSourceConfiguration, importJobType = importJobType, knowledgeBaseId = knowledgeBaseId, metadata = metadata, uploadId = uploadId)
  output <- .connectwisdomservice$start_import_job_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$start_import_job <- connectwisdomservice_start_import_job

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_tag_resource/](https://www.paws-r-sdk.com/docs/connectwisdomservice_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_tag_resource
connectwisdomservice_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .connectwisdomservice$tag_resource_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$tag_resource <- connectwisdomservice_tag_resource

#' Removes the specified tags from the specified resource
#'
#' @description
#' Removes the specified tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_untag_resource/](https://www.paws-r-sdk.com/docs/connectwisdomservice_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The tag keys.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_untag_resource
connectwisdomservice_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .connectwisdomservice$untag_resource_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$untag_resource <- connectwisdomservice_untag_resource

#' Updates information about the content
#'
#' @description
#' Updates information about the content.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_update_content/](https://www.paws-r-sdk.com/docs/connectwisdomservice_update_content/) for full documentation.
#'
#' @param contentId &#91;required&#93; The identifier of the content. Can be either the ID or the ARN. URLs
#' cannot contain the ARN.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN
#' @param metadata A key/value map to store attributes without affecting tagging or
#' recommendations. For example, when synchronizing data between an
#' external system and Wisdom, you can store an external version identifier
#' as metadata to utilize for determining drift.
#' @param overrideLinkOutUri The URI for the article. If the knowledge base has a templateUri,
#' setting this argument overrides it for this piece of content. To remove
#' an existing `overrideLinkOurUri`, exclude this argument and set
#' `removeOverrideLinkOutUri` to true.
#' @param removeOverrideLinkOutUri Unset the existing `overrideLinkOutUri` if it exists.
#' @param revisionId The `revisionId` of the content resource to update, taken from an
#' earlier call to [`get_content`][connectwisdomservice_get_content],
#' [`get_content_summary`][connectwisdomservice_get_content_summary],
#' [`search_content`][connectwisdomservice_search_content], or
#' [`list_contents`][connectwisdomservice_list_contents]. If included, this
#' argument acts as an optimistic lock to ensure content was not modified
#' since it was last read. If it has been modified, this API throws a
#' `PreconditionFailedException`.
#' @param title The title of the content.
#' @param uploadId A pointer to the uploaded asset. This value is returned by
#' [`start_content_upload`][connectwisdomservice_start_content_upload].
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_update_content
connectwisdomservice_update_content <- function(contentId, knowledgeBaseId, metadata = NULL, overrideLinkOutUri = NULL, removeOverrideLinkOutUri = NULL, revisionId = NULL, title = NULL, uploadId = NULL) {
  op <- new_operation(
    name = "UpdateContent",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$update_content_input(contentId = contentId, knowledgeBaseId = knowledgeBaseId, metadata = metadata, overrideLinkOutUri = overrideLinkOutUri, removeOverrideLinkOutUri = removeOverrideLinkOutUri, revisionId = revisionId, title = title, uploadId = uploadId)
  output <- .connectwisdomservice$update_content_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$update_content <- connectwisdomservice_update_content

#' Updates the template URI of a knowledge base
#'
#' @description
#' Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL. Include a single variable in `${variable}` format; this interpolated by Wisdom using ingested content. For example, if you ingest a Salesforce article, it has an `Id` value, and you can set the template URI to `https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*${Id}*/view`.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_update_knowledge_base_template_uri/](https://www.paws-r-sdk.com/docs/connectwisdomservice_update_knowledge_base_template_uri/) for full documentation.
#'
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param templateUri &#91;required&#93; The template URI to update.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_update_knowledge_base_template_uri
connectwisdomservice_update_knowledge_base_template_uri <- function(knowledgeBaseId, templateUri) {
  op <- new_operation(
    name = "UpdateKnowledgeBaseTemplateUri",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/templateUri",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$update_knowledge_base_template_uri_input(knowledgeBaseId = knowledgeBaseId, templateUri = templateUri)
  output <- .connectwisdomservice$update_knowledge_base_template_uri_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$update_knowledge_base_template_uri <- connectwisdomservice_update_knowledge_base_template_uri

#' Updates an existing Wisdom quick response
#'
#' @description
#' Updates an existing Wisdom quick response.
#'
#' See [https://www.paws-r-sdk.com/docs/connectwisdomservice_update_quick_response/](https://www.paws-r-sdk.com/docs/connectwisdomservice_update_quick_response/) for full documentation.
#'
#' @param channels The Amazon Connect contact channels this quick response applies to. The
#' supported contact channel types include `Chat`.
#' @param content The updated content of the quick response.
#' @param contentType The media type of the quick response content.
#' 
#' -   Use `application/x.quickresponse;format=plain` for quick response
#'     written in plain text.
#' 
#' -   Use `application/x.quickresponse;format=markdown` for quick response
#'     written in richtext.
#' @param description The updated description of the quick response.
#' @param groupingConfiguration The updated grouping configuration of the quick response.
#' @param isActive Whether the quick response is active.
#' @param knowledgeBaseId &#91;required&#93; The identifier of the knowledge base. This should not be a
#' QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
#' resource to it. Can be either the ID or the ARN. URLs cannot contain the
#' ARN.
#' @param language The language code value for the language in which the quick response is
#' written. The supported language codes include `de_DE`, `en_US`, `es_ES`,
#' `fr_FR`, `id_ID`, `it_IT`, `ja_JP`, `ko_KR`, `pt_BR`, `zh_CN`, `zh_TW`
#' @param name The name of the quick response.
#' @param quickResponseId &#91;required&#93; The identifier of the quick response.
#' @param removeDescription Whether to remove the description from the quick response.
#' @param removeGroupingConfiguration Whether to remove the grouping configuration of the quick response.
#' @param removeShortcutKey Whether to remove the shortcut key of the quick response.
#' @param shortcutKey The shortcut key of the quick response. The value should be unique
#' across the knowledge base.
#'
#' @keywords internal
#'
#' @rdname connectwisdomservice_update_quick_response
connectwisdomservice_update_quick_response <- function(channels = NULL, content = NULL, contentType = NULL, description = NULL, groupingConfiguration = NULL, isActive = NULL, knowledgeBaseId, language = NULL, name = NULL, quickResponseId, removeDescription = NULL, removeGroupingConfiguration = NULL, removeShortcutKey = NULL, shortcutKey = NULL) {
  op <- new_operation(
    name = "UpdateQuickResponse",
    http_method = "POST",
    http_path = "/knowledgeBases/{knowledgeBaseId}/quickResponses/{quickResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectwisdomservice$update_quick_response_input(channels = channels, content = content, contentType = contentType, description = description, groupingConfiguration = groupingConfiguration, isActive = isActive, knowledgeBaseId = knowledgeBaseId, language = language, name = name, quickResponseId = quickResponseId, removeDescription = removeDescription, removeGroupingConfiguration = removeGroupingConfiguration, removeShortcutKey = removeShortcutKey, shortcutKey = shortcutKey)
  output <- .connectwisdomservice$update_quick_response_output()
  config <- get_config()
  svc <- .connectwisdomservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectwisdomservice$operations$update_quick_response <- connectwisdomservice_update_quick_response
