# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWSMarketplace Metering
#'
#' @description
#' AWS Marketplace Metering Service
#' 
#' This reference provides descriptions of the low-level AWS Marketplace
#' Metering Service API.
#' 
#' AWS Marketplace sellers can use this API to submit usage data for custom
#' usage dimensions.
#' 
#' For information on the permissions you need to use this API, see [AWS
#' Marketplace metering and entitlement API
#' permissions](https://docs.aws.amazon.com/marketplace/latest/userguide/iam-user-policy-for-aws-marketplace-actions.html)
#' in the *AWS Marketplace Seller Guide.*
#' 
#' **Submitting Metering Records**
#' 
#' -   *MeterUsage* - Submits the metering record for an AWS Marketplace
#'     product. [`meter_usage`][marketplacemetering_meter_usage] is called
#'     from an EC2 instance or a container running on EKS or ECS.
#' 
#' -   *BatchMeterUsage* - Submits the metering record for a set of
#'     customers.
#'     [`batch_meter_usage`][marketplacemetering_batch_meter_usage] is
#'     called from a software-as-a-service (SaaS) application.
#' 
#' **Accepting New Customers**
#' 
#' -   *ResolveCustomer* - Called by a SaaS application during the
#'     registration process. When a buyer visits your website during the
#'     registration process, the buyer submits a Registration Token through
#'     the browser. The Registration Token is resolved through this API to
#'     obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId`
#'     and `ProductCode`.
#' 
#' **Entitlement and Metering for Paid Container Products**
#' 
#' -   Paid container software products sold through AWS Marketplace must
#'     integrate with the AWS Marketplace Metering Service and call the
#'     [`register_usage`][marketplacemetering_register_usage] operation for
#'     software entitlement and metering. Free and BYOL products for Amazon
#'     ECS or Amazon EKS aren't required to call
#'     [`register_usage`][marketplacemetering_register_usage], but you can
#'     do so if you want to receive usage data in your seller reports. For
#'     more information on using the
#'     [`register_usage`][marketplacemetering_register_usage] operation,
#'     see [Container-Based
#'     Products](https://docs.aws.amazon.com/marketplace/latest/userguide/container-based-products.html).
#' 
#' [`batch_meter_usage`][marketplacemetering_batch_meter_usage] API calls
#' are captured by AWS CloudTrail. You can use Cloudtrail to verify that
#' the SaaS metering records that you sent are accurate by searching for
#' records with the `eventName` of
#' [`batch_meter_usage`][marketplacemetering_batch_meter_usage]. You can
#' also use CloudTrail to audit records over time. For more information,
#' see the *\href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html}{AWS CloudTrail User Guide}.*
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- marketplacemetering(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- marketplacemetering()
#' svc$batch_meter_usage(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=marketplacemetering_batch_meter_usage]{batch_meter_usage} \tab BatchMeterUsage is called from a SaaS application listed on AWS Marketplace to post metering records for a set of customers\cr
#'  \link[=marketplacemetering_meter_usage]{meter_usage} \tab API to emit metering records\cr
#'  \link[=marketplacemetering_register_usage]{register_usage} \tab Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the RegisterUsage operation for software entitlement and metering\cr
#'  \link[=marketplacemetering_resolve_customer]{resolve_customer} \tab ResolveCustomer is called by a SaaS application during the registration process
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname marketplacemetering
#' @export
marketplacemetering <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .marketplacemetering$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.marketplacemetering <- list()

.marketplacemetering$operations <- list()

.marketplacemetering$metadata <- list(
  service_name = "metering.marketplace",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "metering.marketplace.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "metering.marketplace.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "metering.marketplace.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "metering.marketplace.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "metering.marketplace.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "metering.marketplace.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "metering.marketplace.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Marketplace Metering",
  api_version = "2016-01-14",
  signing_name = "aws-marketplace",
  json_version = "1.1",
  target_prefix = "AWSMPMeteringService"
)

.marketplacemetering$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.marketplacemetering$metadata, handlers, config, op)
}
