# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Cost Explorer Service
#'
#' @description
#' You can use the Cost Explorer API to programmatically query your cost
#' and usage data. You can query for aggregated data such as total monthly
#' costs or total daily usage. You can also query for granular data. This
#' might include the number of daily write operations for Amazon DynamoDB
#' database tables in your production environment.
#' 
#' Service Endpoint
#' 
#' The Cost Explorer API provides the following endpoint:
#' 
#' -   `https://ce.us-east-1.amazonaws.com`
#' 
#' For information about the costs that are associated with the Cost
#' Explorer API, see [Amazon Web Services Cost Management
#' Pricing](https://aws.amazon.com/aws-cost-management/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- costexplorer(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- costexplorer()
#' svc$create_anomaly_monitor(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=costexplorer_create_anomaly_monitor]{create_anomaly_monitor} \tab Creates a new cost anomaly detection monitor with the requested type and monitor specification\cr
#'  \link[=costexplorer_create_anomaly_subscription]{create_anomaly_subscription} \tab Adds an alert subscription to a cost anomaly detection monitor\cr
#'  \link[=costexplorer_create_cost_category_definition]{create_cost_category_definition} \tab Creates a new Cost Category with the requested name and rules\cr
#'  \link[=costexplorer_delete_anomaly_monitor]{delete_anomaly_monitor} \tab Deletes a cost anomaly monitor\cr
#'  \link[=costexplorer_delete_anomaly_subscription]{delete_anomaly_subscription} \tab Deletes a cost anomaly subscription\cr
#'  \link[=costexplorer_delete_cost_category_definition]{delete_cost_category_definition} \tab Deletes a Cost Category\cr
#'  \link[=costexplorer_describe_cost_category_definition]{describe_cost_category_definition} \tab Returns the name, Amazon Resource Name (ARN), rules, definition, and effective dates of a Cost Category that's defined in the account\cr
#'  \link[=costexplorer_get_anomalies]{get_anomalies} \tab Retrieves all of the cost anomalies detected on your account during the time period that's specified by the DateInterval object\cr
#'  \link[=costexplorer_get_anomaly_monitors]{get_anomaly_monitors} \tab Retrieves the cost anomaly monitor definitions for your account\cr
#'  \link[=costexplorer_get_anomaly_subscriptions]{get_anomaly_subscriptions} \tab Retrieves the cost anomaly subscription objects for your account\cr
#'  \link[=costexplorer_get_approximate_usage_records]{get_approximate_usage_records} \tab Retrieves estimated usage records for hourly granularity or resource-level data at daily granularity\cr
#'  \link[=costexplorer_get_commitment_purchase_analysis]{get_commitment_purchase_analysis} \tab Retrieves a commitment purchase analysis result based on the AnalysisId\cr
#'  \link[=costexplorer_get_cost_and_usage]{get_cost_and_usage} \tab Retrieves cost and usage metrics for your account\cr
#'  \link[=costexplorer_get_cost_and_usage_with_resources]{get_cost_and_usage_with_resources} \tab Retrieves cost and usage metrics with resources for your account\cr
#'  \link[=costexplorer_get_cost_categories]{get_cost_categories} \tab Retrieves an array of Cost Category names and values incurred cost\cr
#'  \link[=costexplorer_get_cost_forecast]{get_cost_forecast} \tab Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs\cr
#'  \link[=costexplorer_get_dimension_values]{get_dimension_values} \tab Retrieves all available filter values for a specified filter over a period of time\cr
#'  \link[=costexplorer_get_reservation_coverage]{get_reservation_coverage} \tab Retrieves the reservation coverage for your account, which you can use to see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a reservation\cr
#'  \link[=costexplorer_get_reservation_purchase_recommendation]{get_reservation_purchase_recommendation} \tab Gets recommendations for reservation purchases\cr
#'  \link[=costexplorer_get_reservation_utilization]{get_reservation_utilization} \tab Retrieves the reservation utilization for your account\cr
#'  \link[=costexplorer_get_rightsizing_recommendation]{get_rightsizing_recommendation} \tab Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances\cr
#'  \link[=costexplorer_get_savings_plan_purchase_recommendation_details]{get_savings_plan_purchase_recommendation_details} \tab Retrieves the details for a Savings Plan recommendation\cr
#'  \link[=costexplorer_get_savings_plans_coverage]{get_savings_plans_coverage} \tab Retrieves the Savings Plans covered for your account\cr
#'  \link[=costexplorer_get_savings_plans_purchase_recommendation]{get_savings_plans_purchase_recommendation} \tab Retrieves the Savings Plans recommendations for your account\cr
#'  \link[=costexplorer_get_savings_plans_utilization]{get_savings_plans_utilization} \tab Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity\cr
#'  \link[=costexplorer_get_savings_plans_utilization_details]{get_savings_plans_utilization_details} \tab Retrieves attribute data along with aggregate utilization and savings data for a given time period\cr
#'  \link[=costexplorer_get_tags]{get_tags} \tab Queries for available tag keys and tag values for a specified period\cr
#'  \link[=costexplorer_get_usage_forecast]{get_usage_forecast} \tab Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period that you select, based on your past usage\cr
#'  \link[=costexplorer_list_commitment_purchase_analyses]{list_commitment_purchase_analyses} \tab Lists the commitment purchase analyses for your account\cr
#'  \link[=costexplorer_list_cost_allocation_tag_backfill_history]{list_cost_allocation_tag_backfill_history} \tab Retrieves a list of your historical cost allocation tag backfill requests\cr
#'  \link[=costexplorer_list_cost_allocation_tags]{list_cost_allocation_tags} \tab Get a list of cost allocation tags\cr
#'  \link[=costexplorer_list_cost_category_definitions]{list_cost_category_definitions} \tab Returns the name, Amazon Resource Name (ARN), NumberOfRules and effective dates of all Cost Categories defined in the account\cr
#'  \link[=costexplorer_list_savings_plans_purchase_recommendation_generation]{list_savings_plans_purchase_recommendation_generation} \tab Retrieves a list of your historical recommendation generations within the past 30 days\cr
#'  \link[=costexplorer_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of resource tags associated with the resource specified by the Amazon Resource Name (ARN)\cr
#'  \link[=costexplorer_provide_anomaly_feedback]{provide_anomaly_feedback} \tab Modifies the feedback property of a given cost anomaly\cr
#'  \link[=costexplorer_start_commitment_purchase_analysis]{start_commitment_purchase_analysis} \tab Specifies the parameters of a planned commitment purchase and starts the generation of the analysis\cr
#'  \link[=costexplorer_start_cost_allocation_tag_backfill]{start_cost_allocation_tag_backfill} \tab Request a cost allocation tag backfill\cr
#'  \link[=costexplorer_start_savings_plans_purchase_recommendation_generation]{start_savings_plans_purchase_recommendation_generation} \tab Requests a Savings Plans recommendation generation\cr
#'  \link[=costexplorer_tag_resource]{tag_resource} \tab An API operation for adding one or more tags (key-value pairs) to a resource\cr
#'  \link[=costexplorer_untag_resource]{untag_resource} \tab Removes one or more tags from a resource\cr
#'  \link[=costexplorer_update_anomaly_monitor]{update_anomaly_monitor} \tab Updates an existing cost anomaly monitor\cr
#'  \link[=costexplorer_update_anomaly_subscription]{update_anomaly_subscription} \tab Updates an existing cost anomaly subscription\cr
#'  \link[=costexplorer_update_cost_allocation_tags_status]{update_cost_allocation_tags_status} \tab Updates status for cost allocation tags in bulk, with maximum batch size of 20\cr
#'  \link[=costexplorer_update_cost_category_definition]{update_cost_category_definition} \tab Updates an existing Cost Category
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname costexplorer
#' @export
costexplorer <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .costexplorer$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.costexplorer <- list()

.costexplorer$operations <- list()

.costexplorer$metadata <- list(
  service_name = "ce",
  endpoints = list("aws-global" = list(endpoint = "ce.us-east-1.amazonaws.com", global = TRUE, signing_region = "us-east-1"), "us-east-1" = list(endpoint = "ce.us-east-1.amazonaws.com", global = TRUE), "aws-cn-global" = list(endpoint = "ce.cn-northwest-1.amazonaws.com.cn", global = TRUE, signing_region = "cn-northwest-1"), "cn-northwest-1" = list(endpoint = "ce.cn-northwest-1.amazonaws.com.cn", global = TRUE), "^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "ce.us-east-1.amazonaws.com", global = FALSE, signing_region = "us-east-1"), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "ce.cn-northwest-1.amazonaws.com.cn", global = FALSE, signing_region = "cn-northwest-1"), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "ce.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "ce.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "ce.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "ce.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "ce.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Cost Explorer",
  api_version = "2017-10-25",
  signing_name = "ce",
  json_version = "1.1",
  target_prefix = "AWSInsightsIndexService"
)

.costexplorer$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.costexplorer$metadata, handlers, config, op)
}
