% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_capacity_reservation_billing_owner}
\alias{ec2_associate_capacity_reservation_billing_owner}
\title{Initiates a request to assign billing of the unused capacity of a shared
Capacity Reservation to a consumer account that is consolidated under
the same Amazon Web Services organizations payer account}
\usage{
ec2_associate_capacity_reservation_billing_owner(
  DryRun = NULL,
  CapacityReservationId,
  UnusedReservationBillingOwnerId
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{CapacityReservationId}{[required] The ID of the Capacity Reservation.}

\item{UnusedReservationBillingOwnerId}{[required] The ID of the consumer account to which to assign billing.}
}
\description{
Initiates a request to assign billing of the unused capacity of a shared Capacity Reservation to a consumer account that is consolidated under the same Amazon Web Services organizations payer account. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html}{Billing assignment for shared Amazon EC2 Capacity Reservations}.

See \url{https://www.paws-r-sdk.com/docs/ec2_associate_capacity_reservation_billing_owner/} for full documentation.
}
\keyword{internal}
