% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_data_set}
\alias{quicksight_create_data_set}
\title{Creates a dataset}
\usage{
quicksight_create_data_set(
  AwsAccountId,
  DataSetId,
  Name,
  PhysicalTableMap,
  LogicalTableMap = NULL,
  ImportMode,
  ColumnGroups = NULL,
  FieldFolders = NULL,
  Permissions = NULL,
  RowLevelPermissionDataSet = NULL,
  RowLevelPermissionTagConfiguration = NULL,
  ColumnLevelPermissionRules = NULL,
  Tags = NULL,
  DataSetUsageConfiguration = NULL,
  DatasetParameters = NULL,
  FolderArns = NULL,
  PerformanceConfiguration = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The Amazon Web Services account ID.}

\item{DataSetId}{[required] An ID for the dataset that you want to create. This ID is unique per
Amazon Web Services Region for each Amazon Web Services account.}

\item{Name}{[required] The display name for the dataset.}

\item{PhysicalTableMap}{[required] Declares the physical tables that are available in the underlying data
sources.}

\item{LogicalTableMap}{Configures the combination and transformation of the data from the
physical tables.}

\item{ImportMode}{[required] Indicates whether you want to import the data into SPICE.}

\item{ColumnGroups}{Groupings of columns that work together in certain Amazon QuickSight
features. Currently, only geospatial hierarchy is supported.}

\item{FieldFolders}{The folder that contains fields and nested subfolders for your dataset.}

\item{Permissions}{A list of resource permissions on the dataset.}

\item{RowLevelPermissionDataSet}{The row-level security configuration for the data that you want to
create.}

\item{RowLevelPermissionTagConfiguration}{The configuration of tags on a dataset to set row-level security.
Row-level security tags are currently supported for anonymous embedding
only.}

\item{ColumnLevelPermissionRules}{A set of one or more definitions of a \code{ColumnLevelPermissionRule}.}

\item{Tags}{Contains a map of the key-value pairs for the resource tag or tags
assigned to the dataset.}

\item{DataSetUsageConfiguration}{}

\item{DatasetParameters}{The parameter declarations of the dataset.}

\item{FolderArns}{When you create the dataset, Amazon QuickSight adds the dataset to these
folders.}

\item{PerformanceConfiguration}{The configuration for the performance optimization of the dataset that
contains a \code{UniqueKey} configuration.}
}
\description{
Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.

See \url{https://www.paws-r-sdk.com/docs/quicksight_create_data_set/} for full documentation.
}
\keyword{internal}
