% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_table}
\alias{glue_update_table}
\title{Updates a metadata table in the Data Catalog}
\usage{
glue_update_table(
  CatalogId = NULL,
  DatabaseName,
  TableInput,
  SkipArchive = NULL,
  TransactionId = NULL,
  VersionId = NULL,
  ViewUpdateAction = NULL,
  Force = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the table resides. If none is provided,
the Amazon Web Services account ID is used by default.}

\item{DatabaseName}{[required] The name of the catalog database in which the table resides. For Hive
compatibility, this name is entirely lowercase.}

\item{TableInput}{[required] An updated \code{TableInput} object to define the metadata table in the
catalog.}

\item{SkipArchive}{By default, \code{\link[=glue_update_table]{update_table}} always creates an
archived version of the table before updating it. However, if
\code{skipArchive} is set to true, \code{\link[=glue_update_table]{update_table}} does
not create the archived version.}

\item{TransactionId}{The transaction ID at which to update the table contents.}

\item{VersionId}{The version ID at which to update the table contents.}

\item{ViewUpdateAction}{The operation to be performed when updating the view.}

\item{Force}{A flag that can be set to true to ignore matching storage descriptor and
subobject matching requirements.}
}
\description{
Updates a metadata table in the Data Catalog.

See \url{https://www.paws-r-sdk.com/docs/glue_update_table/} for full documentation.
}
\keyword{internal}
