% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_job_runs}
\alias{datazone_list_job_runs}
\title{Lists job runs}
\usage{
datazone_list_job_runs(
  domainIdentifier,
  jobIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  sortOrder = NULL,
  status = NULL
)
}
\arguments{
\item{domainIdentifier}{[required] The ID of the domain where you want to list job runs.}

\item{jobIdentifier}{[required] The ID of the job run.}

\item{maxResults}{The maximum number of job runs to return in a single call to
ListJobRuns. When the number of job runs to be listed is greater than
the value of MaxResults, the response contains a NextToken value that
you can use in a subsequent call to ListJobRuns to list the next set of
job runs.}

\item{nextToken}{When the number of job runs is greater than the default value for the
MaxResults parameter, or if you explicitly specify a value for
MaxResults that is less than the number of job runs, the response
includes a pagination token named NextToken. You can specify this
NextToken value in a subsequent call to ListJobRuns to list the next set
of job runs.}

\item{sortOrder}{Specifies the order in which job runs are to be sorted.}

\item{status}{The status of a job run.}
}
\description{
Lists job runs.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_job_runs/} for full documentation.
}
\keyword{internal}
