% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_land_mask.R
\name{make_land_mask}
\alias{make_land_mask}
\title{Create a land mask}
\usage{
make_land_mask(relief_rast, time_bp, sea_level = NULL)
}
\arguments{
\item{relief_rast}{a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} with relief}

\item{time_bp}{the time of interest}

\item{sea_level}{sea level at the time of interest (if left to NULL, this is
computed using Spratt 2016)}
}
\value{
a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of the land masks (with land as 1's and sea
as NAs), where the layers are different times
}
\description{
Create a land mask for a given time step. The land mask is based on the
simple logic of moving the ocean up and down given the current relief profile
( topography+bathymetry, i.e. the elevation both above and below sea level).
Note that this approach ignores any rebound due to changing mass and
distribution of ice sheets. LIMITATIONS: The land mask will show internal
lakes/seas as land, as their level is unrelated to the general sea level. If
you have specific reconstructions of internal lakes (or want to simply reuse
their current extents), you will have to add them onto the masks generated by
this function. Also note that the land mask does not include ice sheets. This
means that some areas that are permanently covered by ice at the two poles
will show up as sea. This means that, for any reconstruction including
Greenland or Antarctica, the resulting land mask will need to be modified to
include the appropriate ice sheets.
}
