% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partyfacts.R
\name{lookup_party_url}
\alias{lookup_party_url}
\title{Look up party Wikipedia URL}
\usage{
lookup_party_url(party_name, country = NULL, data = NULL, exact = FALSE)
}
\arguments{
\item{party_name}{A character string to search for in party names. The search
is case-insensitive and matches partial names.}

\item{country}{Optional. ISO 3-letter country code (e.g., "DEU", "USA", "GBR")
to filter results.}

\item{data}{Optional. A Partyfacts dataset (from [get_partyfacts_wikipedia()]).
If not provided, downloads the data automatically.}

\item{exact}{Logical. If `TRUE`, requires exact match on party name.
Default is `FALSE` (partial matching).}
}
\value{
A tibble with matching parties and their Wikipedia URLs.
}
\description{
Search the Partyfacts Wikipedia dataset for a party by name and/or country.
}
\examples{
\donttest{
if (curl::has_internet()) {
  # Search for parties with "Democratic" in the name
  lookup_party_url("Democratic")

  # Search within a specific country
  lookup_party_url("SPD", country = "DEU")

  # Exact match
  lookup_party_url("CDU", country = "DEU", exact = TRUE)
}
}
}
