% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/party_logo.R
\name{download_party_logo}
\alias{download_party_logo}
\title{Download party logo image}
\usage{
download_party_logo(logo_url, destfile, overwrite = FALSE)
}
\arguments{
\item{logo_url}{A character string with the logo URL (from [get_party_logo()]).}

\item{destfile}{Path where the image should be saved.}

\item{overwrite}{Logical. If `TRUE`, overwrite existing files.}
}
\value{
Invisible `TRUE` if successful, `FALSE` otherwise.
}
\description{
Downloads a party logo image from a URL and saves it to a file.
}
\examples{
\donttest{
if (curl::has_internet()) {
  logo_url <- get_party_logo(
    "https://en.wikipedia.org/wiki/Democratic_Party_(United_States)"
  )
  tmp_file <- tempfile(fileext = ".png")
  download_party_logo(logo_url, tmp_file)
  unlink(tmp_file)
}
}
}
