% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{perplexity_calc}
\alias{perplexity_calc}
\title{Calculates perplexity}
\usage{
perplexity_calc(x, na.rm = FALSE, log.p = TRUE)
}
\arguments{
\item{x}{A vector of log-probabilities.}

\item{na.rm}{Should missing values (including NaN) be removed?}

\item{log.p}{If TRUE (default),  x are assumed to be log-transformed
probabilities with base e, if FALSE x are assumed to be
raw probabilities, alternatively log.p can be the base of
other logarithmic transformations.}
}
\value{
The perplexity.
}
\description{
Calculates the perplexity of a vector of (log-)probabilities.
}
\details{
If x are raw probabilities (NOT the default),
then perplexity is calculated as follows:

\deqn{\left(\prod_{n} x_n \right)^\frac{1}{N}}
}
\examples{
probs <- c(.3, .5, .6)
perplexity_calc(probs, log.p = FALSE)
lprobs <- log(probs)
perplexity_calc(lprobs, log.p = TRUE)
}
\concept{general functions}
