% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.cube}
\alias{pal.cube}
\title{Show one palette/colormap in three dimensional RGB or LUV space}
\usage{
pal.cube(pal, n = 100, label = FALSE, type = "RGB")
}
\arguments{
\item{pal}{A palette/colormap function or a vector of colors.}

\item{n}{The number of colors to display for palette functions.}

\item{label}{If TRUE, show color name/value on plot}

\item{type}{Either "RGB" (default) or "LUV".}
}
\value{
None
}
\description{
The palette is converted to RGB or LUV coordinates
and plotted in a three-dimensional scatterplot.
The LUV space is probably better, but it is easier to tweak colors by
hand in RGB space.
}
\details{
What to look for:

A good palette has colors that are spread somewhat uniformly in 3D.

Note: The rgl package is NOT included in "Depends" for the pals
package because it can cause problems for people.  You might have
to manually install rgl with install.packages.
}
\examples{
\dontrun{
pal.cube(cubehelix)
pal.cube(glasbey, n=32) # RGB, blues are too close to each other
pal.cube(glasbey, n=32, type="LUV")
pal.cube(cols25(25), type="LUV", label=TRUE)
# To open a second cube
rgl.open() # Open a new RGL device
rgl.bg(color = "white") # Setup the background color
pal.cube(colors()[c(1:152, 254:260, 362:657)]) # All R non-grey colors
}

}
\references{
None
}
