% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_species.r
\name{cor.mat.fun}
\alias{cor.mat.fun}
\title{Generate correlation matrix}
\usage{
cor.mat.fun(ndim, cors)
}
\arguments{
\item{ndim}{Number of environmental variables that are subsequently generated
with \code{\link{make.env}}.}

\item{cors}{List of correlations between environmental variables.
Each element of the list consists of three numbers,
the first two numbers indicate the variables that are correlated,
the third number is the correlation coefficient.
If correlations between two variables are omitted the correlation remains 0.}
}
\value{
A correlation matrix
}
\description{
Generates a correlation matrix for the environmental variables generated in
\code{\link{make.env}} and for
correlated species optima in \code{\link{species}}.
Only used when correlated environmental variables or optima are generated.
}
\examples{
correlations <- list(c(1, 2, 0.5), c(1, 4, 0.1), c(2, 5, 0.6))
cor.mat <- cor.mat.fun(5, correlations)
}
\seealso{
\code{\link{make.env}}, \code{\link{species}}
}
\author{
Mathias Trachsel
}
\keyword{datagen}
