% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_esa_10m.R
\name{get_esa_10m}
\alias{get_esa_10m}
\title{Download ESA WorldCover land cover data}
\usage{
get_esa_10m(aoi_sf, year = 2020, output_folder = NULL)
}
\arguments{
\item{aoi_sf}{`sf` An sf object defining the area of interest (AOI).
This can be a country, state, or custom boundary.}

\item{year}{`numeric` Year of the land cover data. Available:
- 2020: ESA WorldCover 10 m 2020 v100
- 2021: ESA WorldCover 10 m 2021 v200}

\item{output_folder}{`character` Directory where data files will be saved.
Default is `"."` (current working directory).}
}
\value{
`SpatRaster` A raster object containing land-cover classification
  for the specified AOI and year. The raster values correspond to land-cover
  classes as defined by the ESA WorldCover classification scheme.
}
\description{
Downloads ESA WorldCover land cover data at 10 m resolution for a specified
area of interest (AOI) and year. Useful for landscape ecology studies,
environmental analyses, and habitat mapping.
}
\details{
This function downloads global land-cover raster data produced by the
ESA WorldCover project.
The downloaded file can be large (hundreds of MB), and processing may take
several minutes depending on the AOI size and internet speed.

**Land-cover classification (ESA WorldCover 10 m v200):**

| Value | Class (English)                  | Categoría (Español)                        |
|:------:|:--------------------------------|:-------------------------------------------|
| 10     | Tree cover                     | Cobertura arbórea                          |
| 20     | Shrubland                      | Matorrales                                 |
| 30     | Grassland                      | Pastizales / herbazales                    |
| 40     | Cropland                       | Tierras de cultivo                         |
| 50     | Built-up                       | Áreas construidas / urbanas                |
| 60     | Bare / Sparse vegetation       | Vegetación escasa o suelos desnudos        |
| 70     | Snow and ice                   | Nieve y hielo permanentes                  |
| 80     | Permanent water bodies         | Cuerpos de agua permanentes                |
| 90     | Herbaceous wetland             | Humedales herbáceos                        |
| 95     | Mangroves                      | Manglares                                  |
| 100    | Moss and lichen                | Musgos y líquenes                          |
}
\examples{
\donttest{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))
get_esa_10m(nc, year = 2021, output_folder = tempdir())
}

}
\references{
Zanaga, D., Van De Kerchove, R., De Keersmaecker, W., et al. (2021).
*ESA WorldCover 10 m 2020 v100.* https://doi.org/10.5281/zenodo.5571936
Zanaga, D., Van De Kerchove, R., Daems, D., et al. (2022).
*ESA WorldCover 10 m 2021 v200.* https://doi.org/10.5281/zenodo.7254221
}
