% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairing.R
\name{sample_reverse_pairs}
\alias{sample_reverse_pairs}
\title{Sample reversed versions of a subset of pairs}
\usage{
sample_reverse_pairs(pairs, reverse_pct = NULL, n_reverse = NULL, seed = NULL)
}
\arguments{
\item{pairs}{A data frame or tibble with columns \code{ID1},
\code{text1}, \code{ID2}, and \code{text2}.}

\item{reverse_pct}{Optional proportion of rows to reverse
(between 0 and 1). If \code{n_reverse} is also supplied,
\code{n_reverse} takes precedence and \code{reverse_pct} is ignored.}

\item{n_reverse}{Optional absolute number of rows to reverse.
If supplied, this takes precedence over \code{reverse_pct}.}

\item{seed}{Optional integer seed for reproducible sampling.}
}
\value{
A tibble containing the reversed pairs only (i.e., with
\code{ID1} swapped with \code{ID2} and \code{text1} swapped with
\code{text2}).
}
\description{
Given a table of pairs with columns \code{ID1}, \code{text1},
\code{ID2}, and \code{text2}, this function selects a subset
of rows and returns a new tibble where the order of each selected
pair is reversed.
}
\examples{
data("example_writing_samples")
pairs <- make_pairs(example_writing_samples)

# Reverse 20\% of the pairs
rev20 <- sample_reverse_pairs(pairs, reverse_pct = 0.2, seed = 123)

}
