% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairing.R
\name{randomize_pair_order}
\alias{randomize_pair_order}
\title{Randomly assign samples to positions SAMPLE_1 and SAMPLE_2}
\usage{
randomize_pair_order(pairs, seed = NULL)
}
\arguments{
\item{pairs}{A data frame or tibble with columns \code{ID1}, \code{text1},
\code{ID2}, and \code{text2}. Typically created by \code{\link{make_pairs}}
(optionally followed by \code{\link{sample_pairs}}).}

\item{seed}{Optional integer seed for reproducible randomization. If
\code{NULL} (default), the current RNG state is used and not modified.}
}
\value{
A tibble with the same columns as \code{pairs}, but with some rows'
\code{ID1}/\code{text1} and \code{ID2}/\code{text2} swapped at random.
}
\description{
This helper takes a table of paired writing samples (with columns
\code{ID1}, \code{text1}, \code{ID2}, and \code{text2}) and, for each row,
randomly decides whether to keep the current order or swap the two samples.
The result is that approximately half of the pairs will have the original
order and half will be reversed, on average.
}
\details{
This is useful for reducing position biases in LLM-based paired comparisons,
while still allowing reverse-order consistency checks via
\code{\link{sample_reverse_pairs}} and
\code{\link{compute_reverse_consistency}}.

If you want a \emph{deterministic} alternation of positions (for example,
first pair as-is, second pair swapped, third pair as-is, and so on), use
\code{\link{alternate_pair_order}} instead of this function.
}
\examples{
data("example_writing_samples", package = "pairwiseLLM")

# Build all pairs
pairs_all <- make_pairs(example_writing_samples)

# Randomly flip the order within pairs
set.seed(123)
pairs_rand <- randomize_pair_order(pairs_all, seed = 123)

head(pairs_all[, c("ID1", "ID2")])
head(pairs_rand[, c("ID1", "ID2")])

}
\seealso{
\code{\link{alternate_pair_order}} for deterministic alternating order,
\code{\link{sample_reverse_pairs}} and
\code{\link{compute_reverse_consistency}} for reverse-order checks.
}
