% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt_template.R
\name{get_prompt_template}
\alias{get_prompt_template}
\title{Retrieve a named prompt template}
\usage{
get_prompt_template(name = "default")
}
\arguments{
\item{name}{Character scalar giving the template name.}
}
\value{
A single character string containing the prompt template.
}
\description{
This function retrieves a prompt template from either:
\itemize{
\item the user registry (see \code{\link{register_prompt_template}}), or
\item a built-in template stored under \code{inst/templates}.
}
}
\details{
The function first checks user-registered templates, then looks for
a built-in text file \code{inst/templates/<name>.txt}. The special
name \code{"default"} falls back to \code{\link{set_prompt_template}()}
when no user-registered or built-in template is found.
}
\examples{
# Get the built-in default template
tmpl_default <- get_prompt_template("default")

# List available template names
list_prompt_templates()

}
\seealso{
\code{\link{register_prompt_template}},
\code{\link{list_prompt_templates}},
\code{\link{remove_prompt_template}}
}
