% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.data.R
\docType{data}
\name{naics_classification}
\alias{naics_classification}
\title{Dataset to bridge (translate) common sector-classification codes}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 2125 rows and 5 columns.
}
\usage{
naics_classification
}
\description{
This dataset serves as a translation key between common sector-classification
systems and sectors relevant to the 'PACTA' tool
(\url{https://www.transitionmonitor.com/}).
}
\section{Definitions}{


\itemize{
\item \code{borderline} (logical): Flag indicating if PACTA sector and classification code are a borderline match. The value TRUE indicates that the match is uncertain between the PACTA sector and the classification. The value FALSE indicates that the match is certainly perfect or the classification is certainly out of PACTA's scope.., * \code{code} (character): Six-digit NAICS code., * \code{description} (character): Original NAICS sector title., * \code{sector} (character): Associated PACTA sector., * \code{version} (character): Column identifying which year the classification was published in..
}

}

\section{Details}{


Classification datasets help to standardize sector classification codes from
the wild to a relevant subset including 'power', 'oil and gas', 'coal',
'automotive', 'aviation', 'concrete', 'steel', and 'shipping'.

}

\examples{
head(naics_classification)
}
\seealso{
Other datasets: 
\code{\link{gics_classification}},
\code{\link{increasing_or_decreasing}},
\code{\link{isic_classification}},
\code{\link{iso_codes}},
\code{\link{nace_classification}},
\code{\link{palette_colours}},
\code{\link{psic_classification}},
\code{\link{region_isos}},
\code{\link{scenario_colours}},
\code{\link{sector_classifications}},
\code{\link{sector_colours}},
\code{\link{sic_classification}},
\code{\link{technology_colours}}
}
\concept{datasets}
\keyword{datasets}
