% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.p3state.R
\name{plot.p3state}
\alias{plot.p3state}
\title{Plot method for p3state objects}
\usage{
\method{plot}{p3state}(
  x,
  plot.trans = NULL,
  plot.marginal = NULL,
  plot.bivariate = NULL,
  time1,
  time2,
  xlab,
  ylab,
  zlab,
  col,
  col.biv = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{p3state}.}

\item{plot.trans}{Character or logical; specifies which transition probabilities to plot.
Options include \code{"P11"}, \code{"P12"}, \code{"P22"}, \code{"P23"}, or \code{"all"}.
Defaults to \code{NULL} (no plot).}

\item{plot.marginal}{Logical; whether to plot marginal distributions. Defaults to \code{NULL}.}

\item{plot.bivariate}{Logical; whether to plot the bivariate distribution function. Defaults to \code{NULL}.}

\item{time1}{Numeric; start time for the plot. Defaults to 0 if missing.}

\item{time2}{Numeric; end time for the plot. Defaults to the maximum observed time.}

\item{xlab}{Character; label for the x-axis. Defaults to "Time" if missing.}

\item{ylab}{Character; label for the y-axis. Optional.}

\item{zlab}{Character; label for the z-axis in 3D plots. Optional.}

\item{col}{Color(s) used for plots. Optional.}

\item{col.biv}{Color specification for bivariate contour plots. Optional.}

\item{...}{Additional graphical parameters passed to plotting functions.}
}
\value{
Invisibly returns \code{NULL}. Plots are drawn as side effects.
}
\description{
Produces various plots related to the \code{p3state} model, including transition probabilities,
marginal distributions, and bivariate distribution functions.
}
\examples{
\dontrun{
# Suponha que 'fit' é um objeto p3state ajustado
plot(fit, plot.trans = "P11")
plot(fit, plot.marginal = TRUE)
plot(fit, plot.bivariate = TRUE)
}

}
