% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsal.R
\name{bsal}
\alias{bsal}
\title{basic sensitivity analysis of omitted variable bias}
\usage{
bsal(kd, ky, alpha, data, outcome, treatment, bnch_reg, other_reg)
}
\arguments{
\item{kd}{sensitivity parameter kD (scalar)}

\item{ky}{sensitivity parameter kY (scalar)}

\item{alpha}{significance level for hypothesis test (e.g. 0.05)}

\item{data}{data frame for analysis}

\item{outcome}{name of outcome variable}

\item{treatment}{name of treatment variable}

\item{bnch_reg}{name(s) of benchmark covariate(s)}

\item{other_reg}{name(s) of other regressors}
}
\value{
a matrix with following rows for case 1, 2 and 3 (in columns):
\item{r2yd.x}{partial R2 of Y on D conditioning on X}
\item{r2dz.x}{partial R2 of D on Z conditioning on X}
\item{r2yz.dx}{partial R2 of Y on Z conditioning on D and X}
\item{estimate}{unadjusted parameter estimate}
\item{adjusted_estimate}{bias-adjusted parameter estimate}
\item{adjusted_se}{bias-adjusted standard error}
\item{adjusted_lower_CI}{bias-adjusted confidence interval lower boundary}
\item{adjusted_upper_CI}{bias-adjusted confidence interval upper boundary}
}
\description{
basic sensitivity analysis of omitted variable bias
}
\examples{

require("sensemakr")
Y <- "peacefactor"
D <- "directlyharmed"
X <- "female"
X_oth <- c("village","age","farmer_dar","herder_dar","pastvoted","hhsize_darfur")


res1 <- bsal(kd=1,ky=1,alpha=0.05,data=darfur,outcome=Y,treatment=D,bnch_reg=X,other_reg=X_oth)

}
