% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcomp_ml.R
\name{gcomp_ml_means}
\alias{gcomp_ml_means}
\title{G-computation maximum likelihood mean outcomes by arm}
\usage{
gcomp_ml_means(
  formula,
  family,
  ipd,
  ald,
  trt_var,
  rho = NA,
  N = 1000,
  ref_trt,
  comp_trt,
  marginal_distns = NA,
  marginal_params = NA
)
}
\arguments{
\item{formula}{Linear regression \code{formula} object. Prognostic factors (PF) are main effects and effect modifiers (EM) are
interactions with the treatment variable, e.g., y ~ X1 + trt + trt:X2. For covariates as both PF and EM use \code{*} syntax.}

\item{family}{A 'family' object specifying the distribution and link function (e.g., 'binomial').
See stats::family() for more details.}

\item{ipd}{Individual-level patient data. Dataframe with one row per patient with outcome, treatment and covariate columns.}

\item{ald}{Aggregate-level data. Long format summary statistics for each covariate and treatment outcomes.
We assume a common distribution for each treatment arm.}

\item{rho}{A named square matrix of covariate correlations; default NA.}

\item{N}{Synthetic sample size for g-computation}

\item{marginal_distns, marginal_params}{Marginal distributions and parameters}
}
\value{
A list containing:
\itemize{
\item \code{stats}: Named vector of marginal mean probabilities
\item \code{model}: The fitted glm object
}
}
\description{
G-computation maximum likelihood mean outcomes by arm
}
\seealso{
\code{\link[=strategy_gcomp_ml]{strategy_gcomp_ml()}}, \code{\link[=gcomp_ml.boot]{gcomp_ml.boot()}}
}
\keyword{internal}
